/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.file.it;

import jakarta.enterprise.context.ApplicationScoped;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileFilter;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.quarkus.component.file.it.FileResource;

@ApplicationScoped
public class FileRoutes
extends RouteBuilder {
    public static final String READ_LOCK_IN = "read-lock-in";
    public static final String READ_LOCK_OUT = "read-lock-out";
    private static final Set<String> IDEMPOTENT_FILES_CONSUMED = ConcurrentHashMap.newKeySet();

    public void configure() {
        this.from("file://target/test-files/read-lock-in?initialDelay=0&move=.done&delay=1000&readLock=changed&readLockMinAge=1000&readLockMinLength=100&readLockCheckInterval=2000&readLockLoggingLevel=TRACE&readLockTimeout=5000").to("file://target/test-files/read-lock-out");
        ((RouteDefinition)this.from("file://target/test-files/quartz-scheduled?scheduler=quartz&scheduler.cron=0/1+*+*+*+*+?&repeatCount=0").convertBodyTo(String.class)).to("mock:quartzScheduledFilePolling");
        ((RouteDefinition)this.from("file://target/test-files/batch-in?initialDelay=0&delay=1000").convertBodyTo(String.class)).to("mock:" + FileResource.CONSUME_BATCH);
        ((RouteDefinition)this.from("file://target/test-files/charset-read?initialDelay=0&delay=10&delete=true&charset=ISO-8859-1").convertBodyTo(String.class)).to("mock:charsetIsoRead");
        ((RouteDefinition)((RouteDefinition)this.from("file://target/test-files/idempotent?idempotent=true&move=done/${file:name}&initialDelay=0&delay=10").process(ex -> {
            String fileNameConsumed = (String)ex.getMessage().getHeader("CamelFileNameConsumed", String.class);
            if (IDEMPOTENT_FILES_CONSUMED.add(fileNameConsumed)) {
                ex.getMessage().setHeader("fileNameConsumedStatusHeader", (Object)(fileNameConsumed + "_was-read-once"));
            } else {
                ex.getMessage().setHeader("fileNameConsumedStatusHeader", (Object)(fileNameConsumed + "_was-read-more-than-once"));
            }
        })).convertBodyTo(String.class)).toD("mock:idempotent_${header.fileNameConsumedStatusHeader}");
        this.bindToRegistry("myFilter", new MyFileFilter());
        ((RouteDefinition)this.from("file://target/test-files/filter?initialDelay=0&delay=10&filter=#myFilter").convertBodyTo(String.class)).to("mock:filter");
        ((RouteDefinition)this.from("file://target/test-files/sortby-in?initialDelay=0&delay=10&sortBy=reverse:file:name").convertBodyTo(String.class)).to("mock:" + FileResource.SORT_BY);
        this.from("direct:pollEnrich").pollEnrich("file://target/test-files/poll-enrich?fileName=poll-enrich-file");
    }

    public class MyFileFilter<T>
    implements GenericFileFilter<T> {
        public boolean accept(GenericFile<T> file) {
            if (file.isDirectory()) {
                return true;
            }
            return !file.getFileName().startsWith("skipped_");
        }
    }
}

