/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.file.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;

@Path(value="/file")
@ApplicationScoped
public class FileResource {
    public static String CONSUME_BATCH = "consumeBatch";
    public static String SORT_BY = "sortBy";
    public static String SEPARATOR = ";";
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;
    @Inject
    CamelContext context;

    @Path(value="/get/{folder}/{name}")
    @GET
    @Produces(value={"text/plain"})
    public String getFile(@PathParam(value="folder") String folder, @PathParam(value="name") String name) throws Exception {
        StringBuilder url = new StringBuilder(String.format("file:target/%s?fileName=%s", folder, name));
        String s = (String)this.consumerTemplate.receiveBodyNoWait(url.toString(), String.class);
        return s;
    }

    @Path(value="/getBatch")
    @GET
    @Produces(value={"application/json"})
    public Map<String, Object> getBatch() {
        MockEndpoint mockEndpoint = (MockEndpoint)this.context.getEndpoint("mock:" + CONSUME_BATCH, MockEndpoint.class);
        HashMap<String, Object> result = new HashMap<String, Object>();
        mockEndpoint.getExchanges().stream().forEach(e -> result.put((String)e.getIn().getBody(String.class), e.getProperty("CamelBatchIndex")));
        return result;
    }

    @Path(value="/startRoute")
    @POST
    @Consumes(value={"text/plain"})
    public void startRoute(String routeId) throws Exception {
        this.context.getRouteController().startRoute(routeId);
    }

    @Path(value="/getFromMock/{mockId}")
    @GET
    @Produces(value={"text/plain"})
    public String getFromMock(@PathParam(value="mockId") String mockId) {
        MockEndpoint mockEndpoint = (MockEndpoint)this.context.getEndpoint("mock:" + mockId, MockEndpoint.class);
        String result = mockEndpoint.getExchanges().stream().map(e -> (String)e.getIn().getBody(String.class)).collect(Collectors.joining(SEPARATOR));
        return result;
    }

    @Path(value="/create-file")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response createFile(@QueryParam(value="folder") String folder, String content, @QueryParam(value="charset") String charset, @QueryParam(value="fileName") String fileName) throws Exception {
        StringBuilder url = new StringBuilder("file:target/test-files/" + folder + "?initialDelay=10");
        if (charset != null && !charset.equals("")) {
            url.append("&charset=").append(charset);
        }
        Exchange response = this.producerTemplate.request(url.toString(), exchange -> {
            exchange.getIn().setBody((Object)content);
            if (fileName != null && !fileName.equals("")) {
                exchange.getIn().setHeader("CamelFileName", (Object)fileName);
            }
        });
        return Response.created((URI)new URI("https://camel.apache.org/")).entity(response.getMessage().getHeader("CamelFileNameProduced")).build();
    }

    @Path(value="/create/{folder}")
    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"text/plain"})
    public Response createFile(@PathParam(value="folder") String folder, byte[] content, @QueryParam(value="charset") String charset, @QueryParam(value="fileName") String fileName) throws Exception {
        StringBuilder url = new StringBuilder("file:target/" + folder + "?initialDelay=10");
        if (charset != null && !charset.equals("")) {
            url.append("&charset=").append(charset);
        }
        Exchange response = this.producerTemplate.request(url.toString(), exchange -> {
            exchange.getIn().setBody((Object)content);
            if (fileName != null && !fileName.equals("")) {
                exchange.getIn().setHeader("CamelFileName", (Object)fileName);
            }
        });
        return Response.created((URI)new URI("https://camel.apache.org/")).entity(response.getMessage().getHeader("CamelFileNameProduced")).build();
    }

    @Path(value="/route/{route}")
    @POST
    @Consumes(value={"text/plain"})
    public String pollEnrich(String body, @PathParam(value="route") String route) throws Exception {
        return (String)this.producerTemplate.requestBody("direct:" + route, (Object)body, String.class);
    }
}

