/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.file.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.camel.quarkus.component.file.it.FileResource;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

@QuarkusTest
class FileTest {
    private static final String FILE_BODY = "Hello Camel Quarkus";
    private static final String FILE_CONTENT_01 = "Hello1";
    private static final String FILE_CONTENT_02 = "Hello2";
    private static final String FILE_CONTENT_03 = "Hello3";
    private static final String FILE_BODY_UTF8 = "Hello World \u4f60\u597d";
    private List<Path> pathsToDelete = new LinkedList<Path>();

    FileTest() {
    }

    @AfterEach
    public void afterEach() {
        this.pathsToDelete.stream().forEach(p -> {
            try {
                Files.delete(p);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        this.pathsToDelete.clear();
    }

    @Test
    public void file() throws UnsupportedEncodingException {
        String fileName = FileTest.createFile(FILE_BODY, "/file/create/in");
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/file/get/in/" + Paths.get(fileName, new String[0]).getFileName()), (Object[])new Object[0]).then()).statusCode(200)).body(IsEqual.equalTo((Object)FILE_BODY), new Matcher[0]);
    }

    @Test
    public void charset() throws UnsupportedEncodingException {
        FileTest.createFile(FILE_BODY_UTF8, "/file/create/charsetUTF8", "UTF-8", null);
        FileTest.createFile(FILE_BODY_UTF8, "/file/create/charsetISO", "UTF-8", null);
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> ((ValidatableResponse)RestAssured.get((String)"/file/getFromMock/charsetUTF8", (Object[])new Object[0]).then()).extract().asString(), IsEqual.equalTo((Object)FILE_BODY_UTF8));
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> ((ValidatableResponse)RestAssured.get((String)"/file/getFromMock/charsetISO", (Object[])new Object[0]).then()).extract().asString(), IsEqual.equalTo((Object)new String(FILE_BODY_UTF8.getBytes(), "ISO-8859-1")));
    }

    @Test
    public void batch() throws InterruptedException, UnsupportedEncodingException {
        FileTest.createFile(FILE_CONTENT_01, "/file/create/" + FileResource.CONSUME_BATCH);
        FileTest.createFile(FILE_CONTENT_02, "/file/create/" + FileResource.CONSUME_BATCH);
        FileTest.startRouteAndWait(FileResource.CONSUME_BATCH);
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> {
            Map records = (Map)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/file/getBatch/", (Object[])new Object[0]).then()).statusCode(200)).extract().as(Map.class);
            return records.size() == 2 && records.keySet().contains(FILE_CONTENT_01) && records.keySet().contains(FILE_CONTENT_02) && records.values().contains(0) && records.values().contains(1);
        });
    }

    @Test
    public void idempotent() throws IOException {
        String fileName01 = FileTest.createFile(FILE_CONTENT_01, "/file/create/idempotent");
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> ((ValidatableResponse)RestAssured.get((String)"/file/getFromMock/idempotent", (Object[])new Object[0]).then()).extract().asString(), IsEqual.equalTo((Object)FILE_CONTENT_01));
        Path donePath = Paths.get(fileName01.replaceFirst("target/idempotent", "target/idempotent/done"), new String[0]);
        Path targetPath = Paths.get(fileName01, new String[0]);
        Files.move(donePath, targetPath, new CopyOption[0]);
        this.pathsToDelete.add(targetPath);
        FileTest.createFile(FILE_CONTENT_02, "/file/create/idempotent");
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> ((ValidatableResponse)RestAssured.get((String)"/file/getFromMock/idempotent", (Object[])new Object[0]).then()).extract().asString(), IsEqual.equalTo((Object)FILE_CONTENT_02));
    }

    @Test
    public void filter() throws IOException {
        String fileName = FileTest.createFile(FILE_CONTENT_01, "/file/create/filter", null, "skip_" + UUID.randomUUID().toString());
        FileTest.createFile(FILE_CONTENT_02, "/file/create/filter");
        this.pathsToDelete.add(Paths.get(fileName, new String[0]));
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> ((ValidatableResponse)RestAssured.get((String)"/file/getFromMock/filter", (Object[])new Object[0]).then()).extract().asString(), IsEqual.equalTo((Object)FILE_CONTENT_02));
    }

    @Test
    public void sortBy() throws IOException, InterruptedException {
        FileTest.createFile(FILE_CONTENT_03, "/file/create/" + FileResource.SORT_BY, null, "c_" + UUID.randomUUID().toString());
        FileTest.createFile(FILE_CONTENT_01, "/file/create/" + FileResource.SORT_BY, null, "a_" + UUID.randomUUID().toString());
        FileTest.createFile(FILE_CONTENT_02, "/file/create/" + FileResource.SORT_BY, null, "b_" + UUID.randomUUID().toString());
        FileTest.startRouteAndWait(FileResource.SORT_BY);
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> ((ValidatableResponse)RestAssured.get((String)("/file/getFromMock/" + FileResource.SORT_BY), (Object[])new Object[0]).then()).extract().asString(), IsEqual.equalTo((Object)(FILE_CONTENT_03 + FileResource.SEPARATOR + FILE_CONTENT_02 + FileResource.SEPARATOR + FILE_CONTENT_01)));
    }

    @Test
    public void fileWatchCreateUpdate() throws IOException, InterruptedException {
        Path dir = Files.createTempDirectory(FileTest.class.getSimpleName(), new FileAttribute[0]).toRealPath(new LinkOption[0]);
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("path", new Object[]{dir.toString()}).get("/file-watch/get-events", new Object[0])).then()).statusCode(204);
        Path file = dir.resolve("file.txt");
        Files.write(file, "a file content".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        FileTest.awaitEvent(dir, file, "CREATE");
        Files.write(file, "changed content".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        FileTest.awaitEvent(dir, file, "MODIFY");
        Files.delete(file);
        FileTest.awaitEvent(dir, file, "DELETE");
    }

    @Test
    public void fileReadLock_minLength() throws Exception {
        String fileName = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.BINARY).body(new byte[0]).post("/file/create/{name}", new Object[]{"read-lock-in"})).then()).statusCode(201)).extract().body().asString();
        Thread.sleep(10000L);
        ((ValidatableResponse)RestAssured.get((String)"/file/get/{folder}/{name}", (Object[])new Object[]{"read-lock-out", Paths.get(fileName, new String[0]).getFileName()}).then()).statusCode(204);
    }

    @Test
    public void quartzSchedulerFilePollingConsumer() throws InterruptedException, UnsupportedEncodingException {
        String fileName = FileTest.createFile(FILE_BODY, "/file/create/quartz");
        String targetFileName = Paths.get(fileName, new String[0]).toFile().getName();
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> Files.exists(Paths.get("target/quartz/out", targetFileName), new LinkOption[0]));
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/file/get/{folder}/{name}", (Object[])new Object[]{"quartz/out", targetFileName}).then()).statusCode(200)).body(IsEqual.equalTo((Object)FILE_BODY), new Matcher[0]);
    }

    private static String createFile(String content, String path) throws UnsupportedEncodingException {
        return FileTest.createFile(content.getBytes("UTF-8"), path, null, null);
    }

    static String createFile(String content, String path, String charset, String prefix) throws UnsupportedEncodingException {
        return FileTest.createFile(content.getBytes(), path, charset, prefix);
    }

    static String createFile(byte[] content, String path, String charset, String fileName) {
        return ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().urlEncodingEnabled(true).queryParam("charset", new Object[]{charset}).contentType(ContentType.BINARY).body(content).queryParam("fileName", new Object[]{fileName}).post(path, new Object[0])).then()).statusCode(201)).extract().body().asString();
    }

    static void startRouteAndWait(String routeId) throws InterruptedException {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(routeId).post("/file/startRoute", new Object[0])).then()).statusCode(204);
        Thread.sleep(500L);
    }

    private static void awaitEvent(Path dir, Path file, String type) {
        Awaitility.await().pollInterval(10L, TimeUnit.MILLISECONDS).atMost(20L, TimeUnit.SECONDS).until(() -> {
            ValidatableResponse response = (ValidatableResponse)((Response)RestAssured.given().queryParam("path", new Object[]{dir.toString()}).get("/file-watch/get-events", new Object[0])).then();
            switch (response.extract().statusCode()) {
                case 204: {
                    return false;
                }
                case 200: {
                    JsonPath json = response.extract().jsonPath();
                    return file.toString().equals(json.getString("path")) && type.equals(json.getString("type"));
                }
            }
            throw new RuntimeException("Unexpected status code " + response.extract().statusCode());
        });
    }
}

