/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.file.it;

import java.net.URI;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;

@Path(value="/file")
@ApplicationScoped
public class FileResource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;

    @Path(value="/get/{folder}/{name}")
    @GET
    @Produces(value={"text/plain"})
    public String getFile(@PathParam(value="folder") String folder, @PathParam(value="name") String name) throws Exception {
        return (String)this.consumerTemplate.receiveBodyNoWait("file:target/" + folder + "?fileName=" + name, String.class);
    }

    @Path(value="/create/{folder}")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response createFile(@PathParam(value="folder") String folder, String content) throws Exception {
        Exchange response = this.producerTemplate.request("file:target/" + folder, exchange -> exchange.getIn().setBody((Object)content));
        return Response.created((URI)new URI("https://camel.apache.org/")).entity(response.getMessage().getHeader("CamelFileNameProduced")).build();
    }
}

