/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.file.it;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.file.watch.constants.FileEventEnum;

@Path(value="/file-watch")
@ApplicationScoped
public class FileWatchResource {
    @Inject
    ConsumerTemplate consumerTemplate;

    @Path(value="/get-events")
    @GET
    @Produces(value={"application/json"})
    public Response getEvent(@QueryParam(value="path") String path) throws Exception {
        Exchange exchange = this.consumerTemplate.receiveNoWait("file-watch://" + path);
        if (exchange == null) {
            return Response.noContent().build();
        }
        Message message = exchange.getMessage();
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        node.put("type", ((FileEventEnum)message.getHeader("CamelFileEventType", FileEventEnum.class)).toString());
        node.put("path", (String)message.getHeader("CamelFileAbsolutePath", String.class));
        return Response.ok().entity((Object)node).build();
    }
}

