/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.file.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.jupiter.api.Test;

@QuarkusTest
class FileTest {
    private static final String FILE_BODY = "Hello Camel Quarkus";

    FileTest() {
    }

    @Test
    public void file() {
        String fileName = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(FILE_BODY).post("/file/create/in", new Object[0])).then()).statusCode(201)).extract().body().asString();
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/file/get/in/" + Paths.get(fileName, new String[0]).getFileName()), (Object[])new Object[0]).then()).statusCode(200)).body(IsEqual.equalTo((Object)FILE_BODY), new Matcher[0]);
    }

    @Test
    public void fileWatchCreateUpdate() throws IOException, InterruptedException {
        Path dir = Files.createTempDirectory(FileTest.class.getSimpleName(), new FileAttribute[0]).toRealPath(new LinkOption[0]);
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("path", new Object[]{dir.toString()}).get("/file-watch/get-events", new Object[0])).then()).statusCode(204);
        Path file = dir.resolve("file.txt");
        Files.write(file, "a file content".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        FileTest.awaitEvent(dir, file, "CREATE");
        Files.write(file, "changed content".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        FileTest.awaitEvent(dir, file, "MODIFY");
        Files.delete(file);
        FileTest.awaitEvent(dir, file, "DELETE");
    }

    @Test
    public void fileReadLock_minLength() throws Exception {
        String fileName = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("").post("/file/create/{name}", new Object[]{"read-lock-in"})).then()).statusCode(201)).extract().body().asString();
        Thread.sleep(10000L);
        ((ValidatableResponse)RestAssured.get((String)"/file/get/{folder}/{name}", (Object[])new Object[]{"read-lock-out", Paths.get(fileName, new String[0]).getFileName()}).then()).statusCode(204);
    }

    private static void awaitEvent(Path dir, Path file, String type) {
        Awaitility.await().pollInterval(10L, TimeUnit.MILLISECONDS).atMost(10L, TimeUnit.SECONDS).until(() -> {
            ValidatableResponse response = (ValidatableResponse)((Response)RestAssured.given().queryParam("path", new Object[]{dir.toString()}).get("/file-watch/get-events", new Object[0])).then();
            switch (response.extract().statusCode()) {
                case 204: {
                    return false;
                }
                case 200: {
                    JsonPath json = response.extract().jsonPath();
                    return file.toString().equals(json.getString("path")) && type.equals(json.getString("type"));
                }
            }
            throw new RuntimeException("Unexpected status code " + response.extract().statusCode());
        });
    }
}

