/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.fhir.it.util;

import java.io.IOException;
import java.util.Properties;
import org.apache.camel.quarkus.component.fhir.it.AbstractFhirRouteBuilder;

public final class FhirTestHelper {
    private FhirTestHelper() {
    }

    public static boolean isFhirVersionEnabled(String version) {
        try {
            Properties properties = new Properties();
            properties.load(AbstractFhirRouteBuilder.class.getResourceAsStream("/application.properties"));
            String key = "quarkus.camel.fhir.enable-" + version.toLowerCase();
            String envKey = key.toUpperCase().replace('.', '_');
            String value = (String)properties.getOrDefault((Object)key, System.getProperty(key, System.getenv(envKey)));
            return Boolean.valueOf(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

