/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.fhir.it;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import org.apache.camel.quarkus.component.fhir.it.util.FhirTestHelper;
import org.apache.camel.util.CollectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;

public class FhirTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FhirTestResource.class);
    private static final String FHIR_DSTU_CONTAINER_TAG = "v4.2.0";
    private static final String FHIR_DSTU_CONTEXT_PATH = "/hapi-fhir-jpaserver/fhir";
    private static final String FHIR_R_CONTAINER_TAG = "v5.7.0";
    private static final String FHIR_R_CONTEXT_PATH = "/fhir";
    private static final int CONTAINER_PORT = 8080;
    private FhirVersion fhirVersion;
    private GenericContainer container;

    public void init(Map<String, String> initArgs) {
        this.fhirVersion = FhirVersion.valueOf(initArgs.get("fhirVersion"));
    }

    public Map<String, String> start() {
        if (this.fhirVersion == null) {
            return Collections.emptyMap();
        }
        if (!FhirTestHelper.isFhirVersionEnabled(this.fhirVersion.name())) {
            LOGGER.info("FHIR version {} is disabled. No hapi test container will be started for it.", (Object)this.fhirVersion.simpleVersion());
            return Collections.emptyMap();
        }
        try {
            LOGGER.info("FHIR version {} is enabled. Starting hapi test container for it.", (Object)this.fhirVersion.simpleVersion());
            String imageName = this.fhirVersion.getContainerImageName();
            this.container = new GenericContainer(imageName).withExposedPorts(new Integer[]{8080}).withEnv("HAPI_FHIR_VERSION", this.fhirVersion.getFhirContainerVersionEnvVarValue()).waitingFor(Wait.forHttp((String)this.fhirVersion.getHealthEndpointPath()).withStartupTimeout(Duration.ofMinutes(5L)));
            this.container.start();
            return CollectionHelper.mapOf((Object)String.format("camel.fhir.%s.test-url", this.fhirVersion.simpleVersion()), (Object)this.fhirVersion.getServerUrl(this.container.getContainerIpAddress(), this.container.getMappedPort(8080)), (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static enum FhirVersion {
        DSTU2("v4.2.0", "/hapi-fhir-jpaserver/fhir"),
        DSTU2_HL7ORG("v4.2.0", "/hapi-fhir-jpaserver/fhir"),
        DSTU2_1("v4.2.0", "/hapi-fhir-jpaserver/fhir"),
        DSTU3("v4.2.0", "/hapi-fhir-jpaserver/fhir"),
        R4("v5.7.0", "/fhir"),
        R5("v5.7.0", "/fhir");

        private final String fhirImageTag;
        private final String contextPath;

        private FhirVersion(String fhirImageTag, String contextPath) {
            this.fhirImageTag = fhirImageTag;
            this.contextPath = contextPath;
        }

        public String simpleVersion() {
            return this.name().toLowerCase();
        }

        public String getFhirContainerImageTag() {
            return this.fhirImageTag;
        }

        public String getFhirContainerVersionEnvVarValue() {
            if (this == DSTU2_HL7ORG) {
                return DSTU2.name();
            }
            return this.name();
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public String getContainerImageName() {
            return String.format("hapiproject/hapi:%s", this.getFhirContainerImageTag());
        }

        public String getServerUrl(String host, int port) {
            return String.format("http://%s:%d%s", host, port, this.getContextPath());
        }

        public String getHealthEndpointPath() {
            return String.format("%s/metadata", this.getContextPath());
        }
    }
}

