/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.fhir.it;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

abstract class AbstractFhirTest {
    AbstractFhirTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"fhir2json", "fhir2xml"})
    public void marshalUnmarshal(String path) {
        ((ValidatableResponse)((Response)RestAssured.given().get("/" + path, new Object[0])).then()).statusCode(201);
    }

    @ParameterizedTest
    @ValueSource(strings={"encodeJson", "encodeXml"})
    public void capabilities(String encodeAs) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("encodeAs", new Object[]{encodeAs}).get("/capabilities", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"ACTIVE"), new Matcher[0]);
    }

    @ParameterizedTest
    @ValueSource(strings={"encodeJson", "encodeXml"})
    public void createAsStringResource(String encodeAs) {
        JsonPath result = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("encodeAs", new Object[]{encodeAs}).queryParam("firstName", new Object[]{"Sherlock"}).queryParam("lastName", new Object[]{"Holmes"}).queryParam("address", new Object[]{"221b Baker St, Marylebone, London NW1 6XE, UK"}).contentType(ContentType.TEXT).post("/createPatientAsStringResource", new Object[0])).then()).statusCode(200)).extract().jsonPath();
        try {
            Assertions.assertEquals((Object)true, (Object)result.getBoolean("created"));
            Assertions.assertNotNull((Object)result.getString("id"));
            Assertions.assertNotNull((Object)result.getString("idPart"));
            Assertions.assertNotNull((Object)result.getString("idUnqualifiedVersionless"));
            Assertions.assertNotNull((Object)result.getString("version"));
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @Test
    public void createAsResource() {
        JsonPath result = this.createPatient();
        try {
            Assertions.assertEquals((Object)true, (Object)result.getBoolean("created"));
            Assertions.assertNotNull((Object)result.getString("id"));
            Assertions.assertNotNull((Object)result.getString("idPart"));
            Assertions.assertNotNull((Object)result.getString("idUnqualifiedVersionless"));
            Assertions.assertNotNull((Object)result.getString("version"));
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @Test
    public void deleteByModel() {
        JsonPath result = this.createPatient();
        String deleteEventId = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{result.getString("id")}).delete("/deletePatient/byModel", new Object[0])).then()).statusCode(200)).extract().body().asString();
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{deleteEventId}).get("/readPatient/byId", new Object[0])).then()).statusCode(404);
    }

    @Test
    public void deleteById() {
        JsonPath result = this.createPatient();
        String deleteEventId = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{result.getString("id")}).delete("/deletePatient/byId", new Object[0])).then()).statusCode(200)).extract().body().asString();
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{deleteEventId}).get("/readPatient/byId", new Object[0])).then()).statusCode(404);
    }

    @Test
    public void deleteByIdPart() {
        JsonPath result = this.createPatient();
        String deleteEventId = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{result.getString("idPart")}).delete("/deletePatient/byIdPart", new Object[0])).then()).statusCode(200)).extract().body().asString();
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{deleteEventId}).get("/readPatient/byId", new Object[0])).then()).statusCode(404);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void deleteByUrl(boolean noCache) {
        this.createPatient();
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("noCache", new Object[]{noCache}).delete("/deletePatient/byUrl", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((Response)RestAssured.given().get("/search/byUrl", new Object[0])).then()).statusCode(404);
    }

    @Test
    public void historyOnInstance() {
        JsonPath result = this.createPatient();
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{result.getString("id")}).get("/history/onInstance", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"1"), new Matcher[0]);
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @Test
    public void historyOnServer() {
        JsonPath result = this.createPatient();
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/history/onServer", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"1"), new Matcher[0]);
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @Test
    public void historyOnType() {
        JsonPath result = this.createPatient();
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/history/onType", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"1"), new Matcher[0]);
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @Test
    public void loadPageByUrl() {
        Set<String> ids = Stream.of(this.createPatient("First Name 1", "Last Name 1", "Address 1"), this.createPatient("First Name 2", "Last Name 2", "Address 2"), this.createPatient("First Name 3", "Last Name 3", "Address 3")).map(json -> json.getString("id")).collect(Collectors.toSet());
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/load/page/byUrl", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"2"), new Matcher[0]);
        }
        finally {
            ids.forEach(this::deletePatient);
        }
    }

    @Test
    public void loadPageByNext() {
        Set<String> ids = Stream.of(this.createPatient("First Name 1", "Last Name 1", "Address 1"), this.createPatient("First Name 2", "Last Name 2", "Address 2"), this.createPatient("First Name 3", "Last Name 3", "Address 3")).map(json -> json.getString("id")).collect(Collectors.toSet());
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/load/page/next", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"2"), new Matcher[0]);
        }
        finally {
            ids.forEach(this::deletePatient);
        }
    }

    @Test
    public void loadPageByPrevious() {
        Set<String> ids = Stream.of(this.createPatient("First Name 1", "Last Name 1", "Address 1"), this.createPatient("First Name 2", "Last Name 2", "Address 2"), this.createPatient("First Name 3", "Last Name 3", "Address 3")).map(json -> json.getString("id")).collect(Collectors.toSet());
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("encodeAsXml", new Object[]{false}).get("/load/page/previous", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"2"), new Matcher[0]);
        }
        finally {
            ids.forEach(this::deletePatient);
        }
    }

    @Test
    public void loadPageByPreviousWithEncoding() {
        Set<String> ids = Stream.of(this.createPatient("First Name 1", "Last Name 1", "Address 1"), this.createPatient("First Name 2", "Last Name 2", "Address 2"), this.createPatient("First Name 3", "Last Name 3", "Address 3")).map(json -> json.getString("id")).collect(Collectors.toSet());
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("encodeAsXml", new Object[]{false}).get("/load/page/previous", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"2"), new Matcher[0]);
        }
        finally {
            ids.forEach(this::deletePatient);
        }
    }

    @Test
    public void metaAdd() {
        JsonPath result = this.createPatient();
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{result.getString("id")}).post("/meta", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"1"), new Matcher[0]);
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @Test
    public void metaDelete() {
        JsonPath result = this.createPatient();
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{result.getString("id")}).post("/meta", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"1"), new Matcher[0]);
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{result.getString("id")}).delete("/meta", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"0"), new Matcher[0]);
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @Test
    public void metaGetFromResource() {
        JsonPath result = this.createPatient();
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{result.getString("id")}).post("/meta", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"1"), new Matcher[0]);
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{result.getString("id")}).get("/meta/getFromResource", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"1"), new Matcher[0]);
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @Test
    public void metaGetFromServer() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/meta/getFromServer", new Object[0])).then()).statusCode(200)).body(Matchers.greaterThanOrEqualTo((Comparable)((Object)"2")), new Matcher[0]);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void metaGetFromType(boolean preferResponseType) {
        JsonPath result = this.createPatient();
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{result.getString("id")}).post("/meta", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"1"), new Matcher[0]);
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("preferResponseType", new Object[]{preferResponseType}).get("/meta/getFromType", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"1"), new Matcher[0]);
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @Test
    public void operationOnInstance() {
        JsonPath result = this.createPatient();
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{result.getString("id")}).get("/operation/onInstance", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)result.getString("idUnqualifiedVersionless")), new Matcher[0]);
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @Test
    public void operationOnInstanceVersion() {
        JsonPath result = this.createPatient();
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{result.getString("id")}).get("/operation/onInstanceVersion", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)result.getString("idUnqualifiedVersionless")), new Matcher[0]);
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @Test
    public void operationOnServer() {
        JsonPath result = this.createPatient();
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/operation/onServer", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"true"), new Matcher[0]);
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @Test
    public void operationOnType() {
        JsonPath result = this.createPatient();
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/operation/onType", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)result.getString("idUnqualifiedVersionless")), new Matcher[0]);
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @Disabled(value="ProcessMessage is not implemented on the mock FHIR server")
    @Test
    public void operationProcessMessage() {
        JsonPath result = this.createPatient();
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/operation/processMessage", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)result.getString("id")), new Matcher[0]);
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @Test
    public void patchById() {
        JsonPath result = this.createPatient();
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{result.getString("id")}).body("[ { \"op\":\"add\", \"path\":\"/gender\", \"value\":\"female\" } ]").patch("/patch/byId", new Object[0])).then()).statusCode(200)).body(Matchers.equalToIgnoringCase((String)"Female"), new Matcher[0]);
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void patchByStringId(boolean preferResponseTypes) {
        JsonPath result = this.createPatient();
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{result.getString("id")}).queryParam("preferResponseTypes", new Object[]{preferResponseTypes}).body("[ { \"op\":\"add\", \"path\":\"/gender\", \"value\":\"female\" } ]").patch("/patch/byStringId", new Object[0])).then()).statusCode(200)).body(Matchers.equalToIgnoringCase((String)"female"), new Matcher[0]);
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @Test
    public void patchByUrl() {
        JsonPath result = this.createPatient();
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{result.getString("idPart")}).body("[ { \"op\":\"add\", \"path\":\"/gender\", \"value\":\"female\" } ]").patch("/patch/byUrl", new Object[0])).then()).statusCode(200)).body(Matchers.equalToIgnoringCase((String)"Female"), new Matcher[0]);
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @Test
    public void readById() {
        JsonPath result = this.createPatient();
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{result.getString("id")}).get("/readPatient/byId", new Object[0])).then()).statusCode(200)).body("address", Matchers.is((Object)"221b Baker St, Marylebone, London NW1 6XE, UK"), new Object[]{"firstName", Matchers.is((Object)"Sherlock"), "lastName", Matchers.is((Object)"Holmes")});
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @Test
    public void readByLongId() {
        JsonPath result = this.createPatient();
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{result.getString("idPart")}).get("/readPatient/byLongId", new Object[0])).then()).statusCode(200)).body("address", Matchers.is((Object)"221b Baker St, Marylebone, London NW1 6XE, UK"), new Object[]{"firstName", Matchers.is((Object)"Sherlock"), "lastName", Matchers.is((Object)"Holmes")});
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @Test
    public void readByStringId() {
        JsonPath result = this.createPatient();
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{result.getString("idPart")}).get("/readPatient/byStringId", new Object[0])).then()).statusCode(200)).body("address", Matchers.is((Object)"221b Baker St, Marylebone, London NW1 6XE, UK"), new Object[]{"firstName", Matchers.is((Object)"Sherlock"), "lastName", Matchers.is((Object)"Holmes")});
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @Test
    public void readByIdAndStringResource() {
        JsonPath result = this.createPatient();
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{result.getString("id")}).get("/readPatient/byIdAndStringResource", new Object[0])).then()).statusCode(200)).body("address", Matchers.is((Object)"221b Baker St, Marylebone, London NW1 6XE, UK"), new Object[]{"firstName", Matchers.is((Object)"Sherlock"), "lastName", Matchers.is((Object)"Holmes")});
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @Test
    public void readByLongIdAndStringResource() {
        JsonPath result = this.createPatient();
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{result.getString("idPart")}).get("/readPatient/byLongIdAndStringResource", new Object[0])).then()).statusCode(200)).body("address", Matchers.is((Object)"221b Baker St, Marylebone, London NW1 6XE, UK"), new Object[]{"firstName", Matchers.is((Object)"Sherlock"), "lastName", Matchers.is((Object)"Holmes")});
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @Test
    public void readByStringIdAndStringResource() {
        JsonPath result = this.createPatient();
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{result.getString("idPart")}).get("/readPatient/byStringIdAndStringResource", new Object[0])).then()).statusCode(200)).body("address", Matchers.is((Object)"221b Baker St, Marylebone, London NW1 6XE, UK"), new Object[]{"firstName", Matchers.is((Object)"Sherlock"), "lastName", Matchers.is((Object)"Holmes")});
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @Test
    public void readByStringIdAndVersion() {
        JsonPath result = this.createPatient();
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{result.getString("idPart")}).queryParam("version", new Object[]{result.getString("version")}).get("/readPatient/byStringIdAndVersion", new Object[0])).then()).statusCode(200)).body("address", Matchers.is((Object)"221b Baker St, Marylebone, London NW1 6XE, UK"), new Object[]{"firstName", Matchers.is((Object)"Sherlock"), "lastName", Matchers.is((Object)"Holmes")});
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @Test
    public void readByStringIdAndVersionWithResourceClass() {
        JsonPath result = this.createPatient();
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{result.getString("idPart")}).queryParam("version", new Object[]{result.getString("version")}).get("/readPatient/byStringIdAndVersionWithResourceClass", new Object[0])).then()).statusCode(200)).body("address", Matchers.is((Object)"221b Baker St, Marylebone, London NW1 6XE, UK"), new Object[]{"firstName", Matchers.is((Object)"Sherlock"), "lastName", Matchers.is((Object)"Holmes")});
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @Test
    public void readByIUrl() {
        JsonPath result = this.createPatient();
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{result.getString("id")}).get("/readPatient/byIUrl", new Object[0])).then()).statusCode(200)).body("address", Matchers.is((Object)"221b Baker St, Marylebone, London NW1 6XE, UK"), new Object[]{"firstName", Matchers.is((Object)"Sherlock"), "lastName", Matchers.is((Object)"Holmes")});
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @Test
    public void readByUrl() {
        JsonPath result = this.createPatient();
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{result.getString("id")}).get("/readPatient/byUrl", new Object[0])).then()).statusCode(200)).body("address", Matchers.is((Object)"221b Baker St, Marylebone, London NW1 6XE, UK"), new Object[]{"firstName", Matchers.is((Object)"Sherlock"), "lastName", Matchers.is((Object)"Holmes")});
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @Test
    public void readByStringUrlAndStringResource() {
        JsonPath result = this.createPatient();
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{result.getString("id")}).get("/readPatient/byStringUrlAndStringResource", new Object[0])).then()).statusCode(200)).body("address", Matchers.is((Object)"221b Baker St, Marylebone, London NW1 6XE, UK"), new Object[]{"firstName", Matchers.is((Object)"Sherlock"), "lastName", Matchers.is((Object)"Holmes")});
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void readByUrlAndStringResource(boolean prettyPrint) {
        JsonPath result = this.createPatient();
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("prettyPrint", new Object[]{prettyPrint}).queryParam("id", new Object[]{result.getString("id")}).get("/readPatient/byUrlAndStringResource", new Object[0])).then()).statusCode(200)).body("address", Matchers.is((Object)"221b Baker St, Marylebone, London NW1 6XE, UK"), new Object[]{"firstName", Matchers.is((Object)"Sherlock"), "lastName", Matchers.is((Object)"Holmes")});
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @Test
    public void searchByUrl() {
        JsonPath result = this.createPatient();
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{result.getString("idPart")}).get("/search/byUrl", new Object[0])).then()).statusCode(200)).body("address", Matchers.is((Object)"221b Baker St, Marylebone, London NW1 6XE, UK"), new Object[]{"firstName", Matchers.is((Object)"Sherlock"), "lastName", Matchers.is((Object)"Holmes")});
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @Test
    public void transactionWithBundle() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/transaction/withBundle", new Object[0])).then()).statusCode(200)).body(Matchers.containsString((String)"Created"), new Matcher[0]);
    }

    @Test
    public void transactionWithStringBundle() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/transaction/withStringBundle", new Object[0])).then()).statusCode(200)).body(Matchers.containsString((String)"Created"), new Matcher[0]);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void transactionWithResources(boolean summaryEnum) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("summaryEnum", new Object[]{summaryEnum}).get("/transaction/withResources", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"2"), new Matcher[0]);
    }

    @ParameterizedTest
    @ValueSource(strings={"resource", "resource/withoutId", "resource/withStringId", "resource/asString", "resource/asStringWithStringId"})
    public void updateResource(String updateApiPath) {
        JsonPath result = this.createPatient();
        Assertions.assertNull((Object)result.get("birthDate"));
        try {
            ((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{result.getString("id")}).post("/update/" + updateApiPath, new Object[0])).then()).statusCode(204);
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{result.getString("idPart")}).get("/readPatient/byId", new Object[0])).then()).statusCode(200)).body("birthDate", Matchers.is((Object)"1998-04-29"), new Object[0]);
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"resource/bySearchUrl", "resource/bySearchUrlAndResourceAsString"})
    public void updateResourceByUrl(String updateApiPath) {
        JsonPath result = this.createPatient();
        Assertions.assertNull((Object)result.get("birthDate"));
        try {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{result.getString("id")}).post("/update/" + updateApiPath, new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"1998-04-29"), new Matcher[0]);
        }
        finally {
            this.deletePatient(result.getString("id"));
        }
    }

    @Test
    public void validateResource() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/validate/resource", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"No issues detected during validation"), new Matcher[0]);
    }

    @Test
    public void validateResourceAsString() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/validate/resourceAsString", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"No issues detected during validation"), new Matcher[0]);
    }

    private JsonPath createPatient() {
        return this.createPatient("Sherlock", "Holmes", "221b Baker St, Marylebone, London NW1 6XE, UK");
    }

    private JsonPath createPatient(String firstName, String lastName, String address) {
        return ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("firstName", new Object[]{firstName}).queryParam("lastName", new Object[]{lastName}).queryParam("address", new Object[]{address}).contentType(ContentType.TEXT).post("/createPatient", new Object[0])).then()).statusCode(200)).extract().jsonPath();
    }

    private void deletePatient(String id) {
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{id}).delete("/deletePatient/byId", new Object[0])).then()).statusCode(200);
    }
}

