/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.fhir.it;

import ca.uhn.fhir.rest.api.MethodOutcome;
import java.io.InputStream;
import java.net.URI;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.ProducerTemplate;

@Path(value="/r5")
@ApplicationScoped
public class FhirR5Resource {
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/fhir2json")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream"})
    public Response fhir2json(String patient) throws Exception {
        try (InputStream response = (InputStream)this.producerTemplate.requestBody("direct:json-to-r5", (Object)patient, InputStream.class);){
            Response response2 = Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
            return response2;
        }
    }

    @Path(value="/fhir2xml")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/octet-stream"})
    public Response fhir2xml(String patient) throws Exception {
        try (InputStream response = (InputStream)this.producerTemplate.requestBody("direct:xml-to-r5", (Object)patient, InputStream.class);){
            Response response2 = Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
            return response2;
        }
    }

    @Path(value="/createPatient")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response createPatient(String patient) throws Exception {
        MethodOutcome result = (MethodOutcome)this.producerTemplate.requestBody("direct:create-r5", (Object)patient, MethodOutcome.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)result.getId().getIdPart()).build();
    }
}

