/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.fhir.it;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.IParserErrorHandler;
import ca.uhn.fhir.parser.StrictErrorHandler;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.fhir.FhirJsonDataFormat;
import org.apache.camel.component.fhir.FhirXmlDataFormat;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.quarkus.component.fhir.FhirFlags;
import org.apache.camel.spi.DataFormat;

@ApplicationScoped
public class FhirDstu2RouteBuilder
extends RouteBuilder {
    private static final Boolean ENABLED = new FhirFlags.Dstu2Enabled().getAsBoolean();
    @Inject
    @Named(value="DSTU2")
    FhirContext fhirContext;

    public void configure() {
        if (ENABLED.booleanValue()) {
            this.fhirContext.setParserErrorHandler((IParserErrorHandler)new StrictErrorHandler());
            FhirJsonDataFormat fhirJsonDataFormat = new FhirJsonDataFormat();
            fhirJsonDataFormat.setFhirContext(this.fhirContext);
            fhirJsonDataFormat.setParserErrorHandler((IParserErrorHandler)new StrictErrorHandler());
            FhirXmlDataFormat fhirXmlDataFormat = new FhirXmlDataFormat();
            fhirXmlDataFormat.setFhirContext(this.fhirContext);
            fhirXmlDataFormat.setParserErrorHandler((IParserErrorHandler)new StrictErrorHandler());
            ((RouteDefinition)this.from("direct:json-to-dstu2").unmarshal((DataFormat)fhirJsonDataFormat)).marshal((DataFormat)fhirJsonDataFormat);
            ((RouteDefinition)this.from("direct:xml-to-dstu2").unmarshal((DataFormat)fhirXmlDataFormat)).marshal((DataFormat)fhirXmlDataFormat);
            this.from("direct:create-dstu2").to("fhir://create/resource?inBody=resourceAsString&fhirContext=#DSTU2");
        }
    }
}

