/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.fhir.it;

import java.util.Map;
import org.apache.camel.quarkus.testcontainers.ContainerResourceLifecycleManager;
import org.apache.camel.util.CollectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.TestcontainersConfiguration;

public class FhirTestResource
implements ContainerResourceLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FhirTestResource.class);
    private static final int CONTAINER_PORT = 8080;
    private static final String CONTAINER_IMAGE = "quay.io/lburgazzoli/hapi-fhir-jpaserver-starter:4.1.0";
    private GenericContainer container;

    public Map<String, String> start() {
        LOGGER.info(TestcontainersConfiguration.getInstance().toString());
        try {
            this.container = new GenericContainer(CONTAINER_IMAGE).withExposedPorts(new Integer[]{8080}).withEnv("HAPI_FHIR_VERSION", "DSTU3").waitingFor((WaitStrategy)Wait.forListeningPort());
            this.container.start();
            return CollectionHelper.mapOf((Object)"camel.fhir.test-url", (Object)String.format("http://%s:%d/hapi-fhir-jpaserver/fhir", this.container.getContainerIpAddress(), this.container.getMappedPort(8080)), (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

