/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.fhir.it;

import ca.uhn.fhir.context.FhirContext;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.camel.quarkus.component.fhir.FhirFlags;
import org.apache.camel.quarkus.test.EnabledIf;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Test;

@QuarkusTest
class FhirDataformatTest {
    private static final Logger LOG = Logger.getLogger(FhirDataformatTest.class);

    FhirDataformatTest() {
    }

    @Test
    @EnabledIf(value={FhirFlags.Dstu2Enabled.class})
    public void jsonDstu2() {
        LOG.info((Object)"Running DSTU2 JSON test");
        ca.uhn.fhir.model.dstu2.resource.Patient patient = this.getDstu2Patient();
        String patientString = FhirContext.forDstu2().newJsonParser().encodeResourceToString((IBaseResource)patient);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(patientString).post("/dstu2/fhir2json", new Object[0])).then()).statusCode(201);
    }

    @Test
    @EnabledIf(value={FhirFlags.Dstu2Enabled.class})
    public void xmlDstu2() {
        LOG.info((Object)"Running DSTU2 XML test");
        ca.uhn.fhir.model.dstu2.resource.Patient patient = this.getDstu2Patient();
        String patientString = FhirContext.forDstu2().newXmlParser().encodeResourceToString((IBaseResource)patient);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(patientString).post("/dstu2/fhir2xml", new Object[0])).then()).statusCode(201);
    }

    @Test
    @EnabledIf(value={FhirFlags.Dstu3Enabled.class})
    public void jsonDstu3() {
        LOG.info((Object)"Running DSTU3 JSON test");
        Patient patient = this.getDstu3Patient();
        String patientString = FhirContext.forDstu3().newJsonParser().encodeResourceToString((IBaseResource)patient);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(patientString).post("/dstu3/fhir2json", new Object[0])).then()).statusCode(201);
    }

    @Test
    @EnabledIf(value={FhirFlags.Dstu3Enabled.class})
    public void xmlDstu3() {
        LOG.info((Object)"Running DSTU3 XML test");
        Patient patient = this.getDstu3Patient();
        String patientString = FhirContext.forDstu3().newXmlParser().encodeResourceToString((IBaseResource)patient);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(patientString).post("/dstu3/fhir2xml", new Object[0])).then()).statusCode(201);
    }

    @Test
    @EnabledIf(value={FhirFlags.R4Enabled.class})
    public void jsonR4() {
        LOG.info((Object)"Running R4 JSON test");
        org.hl7.fhir.r4.model.Patient patient = this.getR4Patient();
        String patientString = FhirContext.forR4().newJsonParser().encodeResourceToString((IBaseResource)patient);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(patientString).post("/r4/fhir2json", new Object[0])).then()).statusCode(201);
    }

    @Test
    @EnabledIf(value={FhirFlags.R4Enabled.class})
    public void xmlR4() {
        LOG.info((Object)"Running R4 XML test");
        org.hl7.fhir.r4.model.Patient patient = this.getR4Patient();
        String patientString = FhirContext.forR4().newXmlParser().encodeResourceToString((IBaseResource)patient);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(patientString).post("/r4/fhir2xml", new Object[0])).then()).statusCode(201);
    }

    @Test
    @EnabledIf(value={FhirFlags.R5Enabled.class})
    public void jsonR5() {
        LOG.info((Object)"Running R5 JSON test");
        org.hl7.fhir.r5.model.Patient patient = this.getR5Patient();
        String patientString = FhirContext.forR5().newJsonParser().encodeResourceToString((IBaseResource)patient);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(patientString).post("/r5/fhir2json", new Object[0])).then()).statusCode(201);
    }

    @Test
    @EnabledIf(value={FhirFlags.R5Enabled.class})
    public void xmlR5() {
        LOG.info((Object)"Running R5 XML test");
        org.hl7.fhir.r5.model.Patient patient = this.getR5Patient();
        String patientString = FhirContext.forR5().newXmlParser().encodeResourceToString((IBaseResource)patient);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(patientString).post("/r5/fhir2xml", new Object[0])).then()).statusCode(201);
    }

    private ca.uhn.fhir.model.dstu2.resource.Patient getDstu2Patient() {
        ca.uhn.fhir.model.dstu2.resource.Patient patient = new ca.uhn.fhir.model.dstu2.resource.Patient();
        patient.addName().addGiven("Sherlock").addFamily("Holmes");
        patient.addAddress().addLine("221b Baker St, Marylebone, London NW1 6XE, UK");
        return patient;
    }

    private Patient getDstu3Patient() {
        Patient patient = new Patient();
        patient.addName().addGiven("Sherlock").setFamily("Holmes");
        patient.addAddress().addLine("221b Baker St, Marylebone, London NW1 6XE, UK");
        return patient;
    }

    private org.hl7.fhir.r4.model.Patient getR4Patient() {
        org.hl7.fhir.r4.model.Patient patient = new org.hl7.fhir.r4.model.Patient();
        patient.addAddress().addLine("221b Baker St, Marylebone, London NW1 6XE, UK");
        patient.addName().addGiven("Sherlock").setFamily("Holmes");
        return patient;
    }

    private org.hl7.fhir.r5.model.Patient getR5Patient() {
        org.hl7.fhir.r5.model.Patient patient = new org.hl7.fhir.r5.model.Patient();
        patient.addAddress().addLine("221b Baker St, Marylebone, London NW1 6XE, UK");
        patient.addName().addGiven("Sherlock").setFamily("Holmes");
        return patient;
    }
}

