/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.fhir.it;

import ca.uhn.fhir.context.FhirContext;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.camel.quarkus.component.fhir.FhirFlags;
import org.apache.camel.quarkus.component.fhir.it.FhirTestResource;
import org.apache.camel.quarkus.test.EnabledIf;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=FhirTestResource.class)
class FhirClientTest {
    private static final Logger LOG = Logger.getLogger(FhirClientTest.class);

    FhirClientTest() {
    }

    @Test
    @EnabledIf(value={FhirFlags.R5Enabled.class})
    public void fhirClientR5() {
        LOG.info((Object)"Running R5 Client test");
        org.hl7.fhir.r5.model.Patient patient = this.getR5Patient();
        String patientString = FhirContext.forR5().newJsonParser().encodeResourceToString((IBaseResource)patient);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(patientString.getBytes()).post("/r5/createPatient", new Object[0])).then()).statusCode(201);
    }

    @Test
    @EnabledIf(value={FhirFlags.R4Enabled.class})
    public void fhirClientR4() {
        LOG.info((Object)"Running R4 Client test");
        org.hl7.fhir.r4.model.Patient patient = this.getR4Patient();
        String patientString = FhirContext.forR4().newJsonParser().encodeResourceToString((IBaseResource)patient);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(patientString.getBytes()).post("/r4/createPatient", new Object[0])).then()).statusCode(201);
    }

    @Test
    @EnabledIf(value={FhirFlags.Dstu3Enabled.class})
    public void fhirClientDstu3() {
        LOG.info((Object)"Running DSTU3 Client test");
        Patient patient = this.getDstu3Patient();
        String patientString = FhirContext.forDstu3().newJsonParser().encodeResourceToString((IBaseResource)patient);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(patientString).post("/dstu3/createPatient", new Object[0])).then()).statusCode(201);
    }

    @Test
    @EnabledIf(value={FhirFlags.Dstu2Enabled.class})
    public void fhirClientDstu2() {
        LOG.info((Object)"Running DSTU2 CLIENT test");
        ca.uhn.fhir.model.dstu2.resource.Patient patient = this.getDstu2Patient();
        String patientString = FhirContext.forDstu2().newJsonParser().encodeResourceToString((IBaseResource)patient);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(patientString).post("/dstu2/createPatient", new Object[0])).then()).statusCode(201);
    }

    private ca.uhn.fhir.model.dstu2.resource.Patient getDstu2Patient() {
        ca.uhn.fhir.model.dstu2.resource.Patient patient = new ca.uhn.fhir.model.dstu2.resource.Patient();
        patient.addName().addGiven("Sherlock").addFamily("Holmes");
        patient.addAddress().addLine("221b Baker St, Marylebone, London NW1 6XE, UK");
        return patient;
    }

    private Patient getDstu3Patient() {
        Patient patient = new Patient();
        patient.addName().addGiven("Sherlock").setFamily("Holmes");
        patient.addAddress().addLine("221b Baker St, Marylebone, London NW1 6XE, UK");
        return patient;
    }

    private org.hl7.fhir.r4.model.Patient getR4Patient() {
        org.hl7.fhir.r4.model.Patient patient = new org.hl7.fhir.r4.model.Patient();
        patient.addAddress().addLine("221b Baker St, Marylebone, London NW1 6XE, UK");
        patient.addName().addGiven("Sherlock").setFamily("Holmes");
        return patient;
    }

    private org.hl7.fhir.r5.model.Patient getR5Patient() {
        org.hl7.fhir.r5.model.Patient patient = new org.hl7.fhir.r5.model.Patient();
        patient.addAddress().addLine("221b Baker St, Marylebone, London NW1 6XE, UK");
        patient.addName().addGiven("Sherlock").setFamily("Holmes");
        return patient;
    }
}

