/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.fhir.it;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.parser.IParserErrorHandler;
import ca.uhn.fhir.parser.StrictErrorHandler;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.fhir.FhirJsonDataFormat;
import org.apache.camel.component.fhir.FhirXmlDataFormat;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.quarkus.component.fhir.FhirFlags;
import org.apache.camel.spi.DataFormat;

public class FhirDstu3RouteBuilder
extends RouteBuilder {
    private static final Boolean ENABLED = new FhirFlags.Dstu3Enabled().getAsBoolean();

    public void configure() {
        if (ENABLED.booleanValue()) {
            CamelContext context = this.getContext();
            FhirContext fhirContext = FhirContext.forDstu3();
            fhirContext.setParserErrorHandler((IParserErrorHandler)new StrictErrorHandler());
            context.getRegistry().bind("fhirContext", (Object)fhirContext);
            FhirJsonDataFormat fhirJsonDataFormat = new FhirJsonDataFormat();
            fhirJsonDataFormat.setFhirVersion(FhirVersionEnum.DSTU3.name());
            fhirJsonDataFormat.setParserErrorHandler((IParserErrorHandler)new StrictErrorHandler());
            FhirXmlDataFormat fhirXmlDataFormat = new FhirXmlDataFormat();
            fhirXmlDataFormat.setFhirVersion(FhirVersionEnum.DSTU3.name());
            fhirXmlDataFormat.setParserErrorHandler((IParserErrorHandler)new StrictErrorHandler());
            ((RouteDefinition)this.from("direct:json-to-dstu3").unmarshal((DataFormat)fhirJsonDataFormat)).marshal((DataFormat)fhirJsonDataFormat);
            ((RouteDefinition)this.from("direct:xml-to-dstu3").unmarshal((DataFormat)fhirXmlDataFormat)).marshal((DataFormat)fhirXmlDataFormat);
            this.from("direct:create-dstu3").to("fhir://create/resource?inBody=resourceAsString&fhirVersion=DSTU3&fhirContext=#fhirContext");
        }
    }
}

