/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.elasticsearch.it;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.camel.util.CollectionHelper;
import org.eclipse.microprofile.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.TestcontainersConfiguration;

public class ElasticsearchTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchTestResource.class);
    private static final String ELASTICSEARCH_IMAGE = (String)ConfigProvider.getConfig().getValue("elasticsearch.container.image", String.class);
    private static final String ELASTICSEARCH_USERNAME = "elastic";
    private static final String ELASTICSEARCH_PASSWORD = "changeme";
    private static final int ELASTICSEARCH_PORT = 9200;
    private GenericContainer<?> container;

    public Map<String, String> start() {
        LOGGER.info(TestcontainersConfiguration.getInstance().toString());
        try {
            this.container = new GenericContainer(ELASTICSEARCH_IMAGE).withExposedPorts(new Integer[]{9200}).withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER)).withEnv("discovery.type", "single-node").withEnv("xpack.security.enabled", "true").withEnv("action.destructive_requires_name", "false").withEnv("ELASTIC_USERNAME", ELASTICSEARCH_USERNAME).withEnv("ELASTIC_PASSWORD", ELASTICSEARCH_PASSWORD).waitingFor((WaitStrategy)Wait.forListeningPort());
            this.container.start();
            String hostAddresses = String.format("localhost:%s", this.container.getMappedPort(9200));
            return CollectionHelper.mapOf((Object)"camel.component.elasticsearch.host-addresses", (Object)hostAddresses, (Object[])new Object[]{"camel.component.elasticsearch.user", ELASTICSEARCH_USERNAME, "camel.component.elasticsearch.password", ELASTICSEARCH_PASSWORD});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

