/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.elasticsearch.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.camel.quarkus.component.elasticsearch.it.ElasticsearchTestResource;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@QuarkusTest
@QuarkusTestResource(value=ElasticsearchTestResource.class)
class ElasticsearchTest {
    ElasticsearchTest() {
    }

    @AfterEach
    public void afterEach() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("component", new Object[]{"elasticsearch"}).queryParam("indexName", new Object[]{"_all"}).delete("/elasticsearch/delete/index", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"true"), new Matcher[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"componentNames"})
    public void testElasticsearchBasicOperations(String component) {
        String indexName = UUID.randomUUID().toString();
        String indexKey = "test-key";
        String indexValue = "Hello Camel Quarkus ElasticSearch";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("component", new Object[]{component}).get("/elasticsearch/ping", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"true"), new Matcher[0]);
        String indexId = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("component", new Object[]{component}).queryParam("indexName", new Object[]{indexName}).queryParam("indexKey", new Object[]{indexKey}).contentType(ContentType.TEXT).body(indexValue).post("/elasticsearch/index", new Object[0])).then()).statusCode(201)).extract().body().asString();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("component", new Object[]{component}).queryParam("indexName", new Object[]{indexName}).get("/elasticsearch/exists", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"true"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("component", new Object[]{component}).queryParam("indexName", new Object[]{indexName}).queryParam("indexId", new Object[]{indexId}).queryParam("indexKey", new Object[]{indexKey}).get("/elasticsearch/get", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)indexValue), new Matcher[0]);
        String updatedIndexValue = indexValue + " Updated";
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("component", new Object[]{component}).queryParam("indexId", new Object[]{indexId}).queryParam("indexName", new Object[]{indexName}).queryParam("indexKey", new Object[]{indexKey}).body(updatedIndexValue).patch("/elasticsearch/update", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("component", new Object[]{component}).queryParam("indexName", new Object[]{indexName}).queryParam("indexId", new Object[]{indexId}).queryParam("indexKey", new Object[]{indexKey}).get("/elasticsearch/get", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)updatedIndexValue), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("component", new Object[]{component}).queryParam("indexName", new Object[]{indexName}).queryParam("indexId", new Object[]{indexId}).delete("/elasticsearch/delete", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("component", new Object[]{component}).queryParam("indexName", new Object[]{indexName}).queryParam("indexId", new Object[]{indexId}).queryParam("indexKey", new Object[]{indexKey}).get("/elasticsearch/get", new Object[0])).then()).statusCode(404);
    }

    @ParameterizedTest
    @MethodSource(value={"componentNames"})
    public void testElasticsearchBulk(String component) {
        String indexName = UUID.randomUUID().toString();
        String indexId = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("component", new Object[]{component}).queryParam("indexName", new Object[]{indexName}).post("/elasticsearch/bulk", new Object[0])).then()).statusCode(200)).extract().body().asString();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("component", new Object[]{component}).queryParam("indexName", new Object[]{indexName}).get("/elasticsearch/exists", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"true"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("component", new Object[]{component}).queryParam("indexName", new Object[]{indexName}).queryParam("indexId", new Object[]{indexId}).queryParam("indexKey", new Object[]{"camel"}).get("/elasticsearch/get", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"quarkus"), new Matcher[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"componentNames"})
    public void testElasticsearchDeleteIndex(String component) {
        String indexName = UUID.randomUUID().toString();
        String indexKey = "test-key";
        String indexValue = "Hello Camel Quarkus ElasticSearch";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("component", new Object[]{component}).queryParam("indexName", new Object[]{indexName}).queryParam("indexKey", new Object[]{indexKey}).contentType(ContentType.TEXT).body(indexValue).post("/elasticsearch/index", new Object[0])).then()).statusCode(201)).extract().body().asString();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("component", new Object[]{component}).queryParam("indexName", new Object[]{indexName}).get("/elasticsearch/exists", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"true"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("component", new Object[]{component}).queryParam("indexName", new Object[]{indexName}).delete("/elasticsearch/delete/index", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"true"), new Matcher[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"componentNames"})
    public void testElasticsearchSearch(String component) {
        String indexName = UUID.randomUUID().toString();
        String indexKey = "camel-quarkus";
        String indexValue = "Sub Atomic, Super Fast Camel Quarkus";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("component", new Object[]{component}).queryParam("indexName", new Object[]{indexName}).queryParam("indexKey", new Object[]{indexKey}).contentType(ContentType.TEXT).body(indexValue).post("/elasticsearch/index", new Object[0])).then()).statusCode(201)).extract().body().asString();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("component", new Object[]{component}).queryParam("indexName", new Object[]{indexName}).get("/elasticsearch/exists", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"true"), new Matcher[0]);
        Awaitility.await().pollInterval(50L, TimeUnit.MILLISECONDS).atMost(10L, TimeUnit.SECONDS).until(() -> {
            String searchResult = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("component", new Object[]{component}).queryParam("indexKey", new Object[]{indexKey}).body("Super Fast").get("/elasticsearch/search", new Object[0])).then()).statusCode(200)).extract().body().asString();
            return searchResult.equals(indexValue);
        });
    }

    @ParameterizedTest
    @MethodSource(value={"componentNames"})
    public void testElasticsearchSearchJSON(String component) {
        String indexName = UUID.randomUUID().toString();
        String indexKey = "camel-quarkus";
        String indexValue = "Sub Atomic, Super Fast Camel Quarkus";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("component", new Object[]{component}).queryParam("indexName", new Object[]{indexName}).queryParam("indexKey", new Object[]{indexKey}).contentType(ContentType.TEXT).body(indexValue).post("/elasticsearch/index", new Object[0])).then()).statusCode(201)).extract().body().asString();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("component", new Object[]{component}).queryParam("indexName", new Object[]{indexName}).get("/elasticsearch/exists", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"true"), new Matcher[0]);
        Awaitility.await().pollInterval(50L, TimeUnit.MILLISECONDS).atMost(10L, TimeUnit.SECONDS).until(() -> {
            String searchResult = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("component", new Object[]{component}).queryParam("indexKey", new Object[]{indexKey}).body("Super Fast").get("/elasticsearch/search/json", new Object[0])).then()).statusCode(200)).extract().body().asString();
            return searchResult.equals(indexValue);
        });
    }

    @ParameterizedTest
    @MethodSource(value={"componentNames"})
    public void testElasticsearchMultiSearch(String component) {
        String indexName = UUID.randomUUID().toString();
        String indexKey = "camel-quarkus";
        String indexValue = "Sub Atomic, Super Fast Camel Quarkus";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("component", new Object[]{component}).queryParam("indexName", new Object[]{indexName}).queryParam("indexKey", new Object[]{indexKey}).contentType(ContentType.TEXT).body(indexValue).post("/elasticsearch/index", new Object[0])).then()).statusCode(201)).extract().body().asString();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("component", new Object[]{component}).queryParam("indexName", new Object[]{indexName}).get("/elasticsearch/exists", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"true"), new Matcher[0]);
        Awaitility.await().pollInterval(50L, TimeUnit.MILLISECONDS).atMost(100L, TimeUnit.SECONDS).until(() -> {
            String hits = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("component", new Object[]{component}).queryParam("indexName", new Object[]{indexName}).queryParam("indexKey", new Object[]{indexKey}).body("Sub Atomic,Super Fast,Nonsense").get("/elasticsearch/search/multi", new Object[0])).then()).statusCode(200)).extract().body().asString();
            return hits.equals("2");
        });
    }

    private static String[] componentNames() {
        return new String[]{"elasticsearch"};
    }
}

