/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.elasticsearch.it;

import co.elastic.clients.elasticsearch._types.query_dsl.MatchPhraseQuery;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.GetResponse;
import co.elastic.clients.elasticsearch.core.MsearchRequest;
import co.elastic.clients.elasticsearch.core.bulk.BulkOperation;
import co.elastic.clients.elasticsearch.core.bulk.BulkResponseItem;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import co.elastic.clients.elasticsearch.core.msearch.MultiSearchResponseItem;
import co.elastic.clients.elasticsearch.core.msearch.MultisearchBody;
import co.elastic.clients.elasticsearch.core.msearch.MultisearchHeader;
import co.elastic.clients.elasticsearch.core.msearch.RequestItem;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.elasticsearch.core.search.HitsMetadata;
import co.elastic.clients.elasticsearch.indices.DeleteIndexRequest;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.FluentProducerTemplate;

@Path(value="/elasticsearch")
@ApplicationScoped
public class ElasticsearchResource {
    private static final String HEADER_COMPONENT = "component";
    @Inject
    FluentProducerTemplate fluentProducerTemplate;

    @Path(value="/get")
    @GET
    @Produces(value={"text/plain"})
    public Response getData(@QueryParam(value="component") String component, @QueryParam(value="indexName") String indexName, @QueryParam(value="indexId") String indexId, @QueryParam(value="indexKey") String indexKey) {
        GetResponse response = (GetResponse)this.fluentProducerTemplate.to("direct:get").withBody((Object)indexId).withHeader("indexName", (Object)indexName).withHeader(HEADER_COMPONENT, (Object)component).request(GetResponse.class);
        if (response.source() == null || !(response.source() instanceof ObjectNode)) {
            return Response.status((int)404).build();
        }
        return Response.ok().entity((Object)((ObjectNode)response.source()).get(indexKey).asText()).build();
    }

    @Path(value="/index")
    @POST
    @Produces(value={"text/plain"})
    public Response indexData(@QueryParam(value="component") String component, @QueryParam(value="indexName") String indexName, @QueryParam(value="indexKey") String indexKey, String indexValue) throws Exception {
        String indexId = (String)this.fluentProducerTemplate.to("direct:index").withBody(this.createIndexedData(indexKey, indexValue)).withHeader("indexName", (Object)indexName).withHeader(HEADER_COMPONENT, (Object)component).request(String.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)indexId).build();
    }

    @Path(value="/update")
    @PATCH
    @Produces(value={"text/plain"})
    public Response updateData(@QueryParam(value="component") String component, @QueryParam(value="indexName") String indexName, @QueryParam(value="indexId") String indexId, @QueryParam(value="indexKey") String indexKey, String indexValue) {
        this.fluentProducerTemplate.to("direct:update").withBody(Map.of("doc", this.createIndexedData(indexKey, indexValue))).withHeader("indexName", (Object)indexName).withHeader("indexId", (Object)indexId).withHeader(HEADER_COMPONENT, (Object)component).request();
        return Response.ok().build();
    }

    @Path(value="/delete")
    @DELETE
    @Produces(value={"text/plain"})
    public Response deleteData(@QueryParam(value="component") String component, @QueryParam(value="indexName") String indexName, @QueryParam(value="indexId") String indexId) {
        this.fluentProducerTemplate.to("direct:delete").withBody((Object)indexId).withHeader("indexName", (Object)indexName).withHeader(HEADER_COMPONENT, (Object)component).request();
        return Response.noContent().build();
    }

    @Path(value="/delete/index")
    @DELETE
    @Produces(value={"text/plain"})
    public Response deleteIndexData(@QueryParam(value="component") String component, @QueryParam(value="indexName") String indexName) {
        DeleteIndexRequest.Builder request = new DeleteIndexRequest.Builder().index(indexName, new String[0]);
        Boolean result = (Boolean)this.fluentProducerTemplate.to("direct:deleteIndex").withBody((Object)request).withHeader(HEADER_COMPONENT, (Object)component).request(Boolean.class);
        return Response.ok((Object)result).build();
    }

    @Path(value="/ping")
    @GET
    @Produces(value={"text/plain"})
    public Response ping(@QueryParam(value="component") String component) {
        Boolean result = (Boolean)this.fluentProducerTemplate.to("direct:ping").withHeader(HEADER_COMPONENT, (Object)component).request(Boolean.class);
        return Response.ok((Object)result).build();
    }

    @Path(value="/exists")
    @GET
    @Produces(value={"text/plain"})
    public Response exists(@QueryParam(value="component") String component, @QueryParam(value="indexName") String indexName) {
        Boolean result = (Boolean)this.fluentProducerTemplate.to("direct:exists").withHeader("indexName", (Object)indexName).withHeader(HEADER_COMPONENT, (Object)component).request(Boolean.class);
        return Response.ok((Object)result).build();
    }

    @Path(value="/bulk")
    @POST
    @Produces(value={"text/plain"})
    public Response bulk(@QueryParam(value="component") String component, @QueryParam(value="indexName") String indexName) {
        BulkRequest.Builder request = new BulkRequest.Builder();
        request.operations((BulkOperation)new BulkOperation.Builder().index(((IndexOperation.Builder)new IndexOperation.Builder().index(indexName)).document(Map.of("camel", "quarkus")).build()).build(), new BulkOperation[0]);
        BulkResponseItem[] result = (BulkResponseItem[])this.fluentProducerTemplate.to("direct:bulk").withBody((Object)request).withHeader(HEADER_COMPONENT, (Object)component).request(BulkResponseItem[].class);
        return Response.ok((Object)result[0].id()).build();
    }

    @Path(value="/search")
    @GET
    @Produces(value={"text/plain"})
    public Response searchByMap(@QueryParam(value="component") String component, @QueryParam(value="indexKey") String indexKey, String searchString) {
        Object source;
        HashMap<String, String> actualQuery = new HashMap<String, String>();
        actualQuery.put(indexKey, searchString);
        HashMap<String, HashMap<String, String>> match = new HashMap<String, HashMap<String, String>>();
        match.put("match", actualQuery);
        HashMap<String, HashMap<String, HashMap<String, String>>> query = new HashMap<String, HashMap<String, HashMap<String, String>>>();
        query.put("query", match);
        HitsMetadata result = (HitsMetadata)this.fluentProducerTemplate.to("direct:search").withBody(query).withHeader(HEADER_COMPONENT, (Object)component).request(HitsMetadata.class);
        if (result.hits().size() > 0 && (source = ((Hit)result.hits().get(0)).source()) instanceof ObjectNode) {
            return Response.ok((Object)((ObjectNode)source).get(indexKey).asText()).build();
        }
        return Response.ok().build();
    }

    @Path(value="/search/json")
    @GET
    @Produces(value={"text/plain"})
    public Response searchByJSON(@QueryParam(value="component") String component, @QueryParam(value="indexKey") String indexKey, String searchString) {
        Object source;
        String query = "{\"query\":{\"match\":{\"%s\":\"%s\"}}}";
        HitsMetadata result = (HitsMetadata)this.fluentProducerTemplate.to("direct:search").withBody((Object)String.format(query, indexKey, searchString)).withHeader(HEADER_COMPONENT, (Object)component).request(HitsMetadata.class);
        if (result.hits().size() > 0 && (source = ((Hit)result.hits().get(0)).source()) instanceof ObjectNode) {
            return Response.ok((Object)((ObjectNode)source).get(indexKey).asText()).build();
        }
        return Response.ok().build();
    }

    @Path(value="/search/multi")
    @GET
    @Produces(value={"text/plain"})
    public Response searchMulti(@QueryParam(value="component") String component, @QueryParam(value="indexName") String indexName, @QueryParam(value="indexKey") String indexKey, String searchStrings) {
        String[] searchTerms = searchStrings.split(",");
        MsearchRequest.Builder builder = new MsearchRequest.Builder().index(indexName, new String[0]);
        for (String searchTerm : searchTerms) {
            builder.searches(new RequestItem.Builder().header(new MultisearchHeader.Builder().build()).body(new MultisearchBody.Builder().query(q -> q.matchPhrase(new MatchPhraseQuery.Builder().field(indexKey).query(searchTerm).build())).build()).build(), new RequestItem[0]);
        }
        MultiSearchResponseItem[] result = (MultiSearchResponseItem[])this.fluentProducerTemplate.to("direct:multiSearch").withBody((Object)builder).withHeader(HEADER_COMPONENT, (Object)component).request(MultiSearchResponseItem[].class);
        if (result.length > 0) {
            int totalHits = 0;
            for (MultiSearchResponseItem item : result) {
                totalHits = (int)((long)totalHits + item.result().hits().total().value());
            }
            return Response.ok((Object)totalHits).build();
        }
        return Response.ok().build();
    }

    private Map<String, String> createIndexedData(String indexKey, String indexValue) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(indexKey, indexValue);
        return map;
    }
}

