/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.eip.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;

@Path(value="/eip")
@ApplicationScoped
public class EipResource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    CamelContext context;

    @Path(value="/routeAsync/{route}")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response routeAsync(String statement, @PathParam(value="route") String route, @Context UriInfo uriInfo) {
        return this.route(statement, route, uriInfo, true);
    }

    @Path(value="/route/{route}")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response routeSync(String statement, @PathParam(value="route") String route, @Context UriInfo uriInfo) {
        return this.route(statement, route, uriInfo, false);
    }

    public Response route(String statement, String route, @Context UriInfo uriInfo, boolean async) {
        Map<String, Object> headers = uriInfo.getQueryParameters().entrySet().stream().map(e -> new AbstractMap.SimpleImmutableEntry((String)e.getKey(), ((List)e.getValue()).get(0))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        try {
            if (async) {
                this.producerTemplate.asyncRequestBodyAndHeaders("direct:" + route, (Object)statement, headers, String.class);
                return Response.ok().build();
            }
            String result = (String)this.producerTemplate.requestBodyAndHeaders("direct:" + route, (Object)statement, headers, String.class);
            System.out.println("---- result for " + statement + " is " + result);
            return Response.ok((Object)result).build();
        }
        catch (CamelExecutionException e2) {
            return Response.serverError().entity((Object)e2.getMessage()).build();
        }
    }

    @Path(value="/mock/{name}/{count}/{timeout}/{part}")
    @Produces(value={"text/plain"})
    @GET
    public String mockHeader(@PathParam(value="name") String name, @PathParam(value="count") String count, @PathParam(value="timeout") int timeout, @PathParam(value="part") String part) {
        MockEndpoint mock = (MockEndpoint)this.context.getEndpoint("mock:" + name, MockEndpoint.class);
        if (count.endsWith("+")) {
            mock.setMinimumExpectedMessageCount(Integer.valueOf(count.substring(0, count.length() - 1)).intValue());
        } else {
            mock.setExpectedMessageCount(Integer.valueOf(count).intValue());
        }
        try {
            mock.assertIsSatisfied((long)timeout);
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
        }
        switch (part) {
            case "body": {
                return mock.getExchanges().stream().map(e -> (String)e.getMessage().getBody(String.class)).collect(Collectors.joining(","));
            }
            case "header": {
                return mock.getExchanges().stream().flatMap(e -> e.getMessage().getHeaders().entrySet().stream().map(entry -> (String)entry.getKey() + "=" + entry.getValue())).collect(Collectors.joining(","));
            }
            case "property": {
                return mock.getExchanges().stream().flatMap(e -> e.getProperties().entrySet().stream().map(entry -> (String)entry.getKey() + "=" + entry.getValue())).collect(Collectors.joining(","));
            }
        }
        throw new IllegalStateException("Unexpected part " + part);
    }
}

