/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.eip.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Test;

@QuarkusTest
class EipTest {
    private static final Logger LOG = Logger.getLogger(EipTest.class);

    EipTest() {
    }

    @Test
    public void claimCheckByHeader() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("Secret").queryParam("claimCheckId", new Object[]{"foo"}).post("/eip/route/claimCheckByHeader", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/claimCheckByHeader/4/10000/body", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"Bye World,Secret,Hi World,Secret"), new Matcher[0]);
    }

    @Test
    public void customLoadBalancer() {
        List<String> messages = Arrays.asList("a", "b", "c", "d");
        for (String msg : messages) {
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/eip/route/customLoadBalancer", new Object[0])).then()).statusCode(200);
        }
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/customLoadBalancer1/2/10000/body", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"a,c"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/customLoadBalancer2/2/10000/body", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"b,d"), new Matcher[0]);
    }

    @Test
    public void roundRobinLoadBalancer() {
        List<String> messages = Arrays.asList("a", "b", "c", "d");
        for (String msg : messages) {
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/eip/route/roundRobinLoadBalancer", new Object[0])).then()).statusCode(200);
        }
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/roundRobinLoadBalancer1/2/10000/body", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"a,c"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/roundRobinLoadBalancer2/2/10000/body", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"b,d"), new Matcher[0]);
    }

    @Test
    public void stickyLoadBalancer() {
        List<String> messages = Arrays.asList("a", "b", "c", "d");
        int i = 0;
        for (String msg : messages) {
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("stickyKey", new Object[]{String.valueOf(1 + i++ % 2)}).body(msg).post("/eip/route/stickyLoadBalancer", new Object[0])).then()).statusCode(200);
        }
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/stickyLoadBalancer1/2/10000/body", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"a,c"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/stickyLoadBalancer2/2/10000/body", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"b,d"), new Matcher[0]);
    }

    @Test
    public void weightedLoadBalancer() {
        int msgCount = 60;
        LOG.infof("Sending %d messages", (Object)60);
        for (int i = 0; i < 60; ++i) {
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("hello " + i).post("/eip/route/weightedLoadBalancer", new Object[0])).then()).statusCode(200);
        }
        int tolerance = 2;
        int expectedCount1 = 40;
        int expectedCount2 = 20;
        int actualCount1 = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/weightedLoadBalancer1/38+/10000/body", (Object[])new Object[0]).then()).statusCode(200)).extract().body().asString().split(",").length;
        int actualCount2 = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/weightedLoadBalancer2/18+/10000/body", (Object[])new Object[0]).then()).statusCode(200)).extract().body().asString().split(",").length;
        LOG.infof("Expected message distribution %d:%d, got %d:%d", new Object[]{40, 20, actualCount1, actualCount2});
        Assertions.assertThat((int)actualCount1).isBetween(Integer.valueOf(38), Integer.valueOf(42));
        Assertions.assertThat((int)actualCount2).isBetween(Integer.valueOf(18), Integer.valueOf(22));
    }

    @Test
    public void enrich() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("Franz").post("/eip/route/enrich", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello Franz"), new Matcher[0]);
    }

    @Test
    public void failover() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("Arthur").post("/eip/route/failover", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello from failover2 Arthur"), new Matcher[0]);
    }

    @Test
    public void loop() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("foo").post("/eip/route/loop", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/loop/3/5000/body", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"foo,foo,foo"), new Matcher[0]);
    }

    @Test
    public void multicast() {
        List<String> messages = Arrays.asList("a", "b", "c", "d");
        for (String msg : messages) {
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/eip/route/multicast", new Object[0])).then()).statusCode(200);
        }
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/multicast1/4/5000/body", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"a,b,c,d"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/multicast2/4/5000/body", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"a,b,c,d"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/multicast3/4/5000/body", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"a,b,c,d"), new Matcher[0]);
    }

    @Test
    public void recipientList() {
        List<String> messages = Arrays.asList("a", "b", "c", "d");
        for (String msg : messages) {
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/eip/route/recipientList", new Object[0])).then()).statusCode(200);
        }
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/recipientList1/4/5000/body", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"a,b,c,d"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/recipientList2/4/5000/body", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"a,b,c,d"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/recipientList3/4/5000/body", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"a,b,c,d"), new Matcher[0]);
    }

    @Test
    public void removeHeader() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("baz").queryParam("headerToKeep", new Object[]{"foo"}).queryParam("headerToRemove", new Object[]{"bar"}).post("/eip/route/removeHeader", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/removeHeader/1/5000/header", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.allOf((Matcher)Matchers.containsString((String)"headerToKeep=foo"), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"headerToRemove"))), new Matcher[0]);
    }

    @Test
    public void removeHeaders() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("baz").queryParam("headerToKeep", new Object[]{"keepFoo"}).queryParam("headerToRemove1", new Object[]{"bar1"}).queryParam("headerToRemove2", new Object[]{"bar2"}).post("/eip/route/removeHeaders", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/removeHeaders/1/5000/header", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.allOf((Matcher)Matchers.containsString((String)"headerToKeep=keepFoo"), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"headerToRemove1")), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"headerToRemove2"))), new Matcher[0]);
    }

    @Test
    public void removeProperty() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("baz").queryParam("propertyToKeep", new Object[]{"keep"}).queryParam("propertyToRemove", new Object[]{"bar"}).post("/eip/route/removeProperty", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/removeProperty/1/5000/property", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.allOf((Matcher)Matchers.containsString((String)"propertyToKeep=keep"), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"propertyToRemove"))), new Matcher[0]);
    }

    @Test
    public void removeProperties() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("baz").queryParam("propertyToKeep", new Object[]{"keepProp"}).queryParam("propertyToRemove1", new Object[]{"bar1"}).queryParam("propertyToRemove2", new Object[]{"bar2"}).post("/eip/route/removeProperties", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/removeProperties/1/5000/property", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.allOf((Matcher)Matchers.containsString((String)"propertyToKeep=keepProp"), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"propertyToRemove1")), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"propertyToRemove2"))), new Matcher[0]);
    }

    @Test
    public void routingSlip() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("message-1").queryParam("routingSlipHeader", new Object[]{"mock:routingSlip1,mock:routingSlip2"}).post("/eip/route/routingSlip", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("message-2").queryParam("routingSlipHeader", new Object[]{"mock:routingSlip2,mock:routingSlip3"}).post("/eip/route/routingSlip", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/routingSlip1/1/5000/body", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"message-1"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/routingSlip2/2/5000/body", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"message-1,message-2"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/routingSlip3/1/5000/body", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"message-2"), new Matcher[0]);
    }

    @Test
    public void sample() {
        int durationSec = 2;
        LOG.infof("About to sent messages for %d seconds", (Object)2);
        long deadline = System.currentTimeMillis() + 2000L;
        int i = 0;
        while (System.currentTimeMillis() < deadline) {
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("message-" + i++).post("/eip/route/sample", new Object[0])).then()).statusCode(200);
        }
        LOG.infof("Sent %d messages", (Object)i);
        int overratedSampleUpperBound = 3;
        Assertions.assertThat((int)i).isGreaterThan(overratedSampleUpperBound);
        String[] samples = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/sample/1+/5000/body", (Object[])new Object[0]).then()).statusCode(200)).extract().body().asString().split(",");
        LOG.infof("Got %d samples", (Object)samples.length);
        Assertions.assertThat((int)samples.length).isBetween(Integer.valueOf(1), Integer.valueOf(overratedSampleUpperBound));
    }

    @Test
    public void step() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("Monty").post("/eip/route/step", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello Monty from step!"), new Matcher[0]);
    }

    @Test
    public void resequenceStream() {
        List<String> messages = Arrays.asList("a:2", "b:1", "c:4", "d:3");
        for (String input : messages) {
            String[] message = input.split(":");
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("seqno", new Object[]{message[1]}).body(message[0]).post("/eip/route/resequenceStream", new Object[0])).then()).statusCode(200);
        }
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/resequenceStream/4/10000/body", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"b,a,d,c"), new Matcher[0]);
    }

    @Test
    public void threads() {
        HashSet<String> threadNames = new HashSet<String>();
        int period = 10000;
        long deadline = System.currentTimeMillis() + 10000L;
        int expectedThreadCount = 2;
        do {
            if (System.currentTimeMillis() >= deadline) {
                Assertions.fail((String)("Have not seen 2 distict thread names within 10000 ms; thread names seen so far: " + threadNames));
            }
            String threadName = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("foo").post("/eip/route/threads", new Object[0])).then()).statusCode(200)).extract().body().asString();
            threadNames.add(threadName);
        } while (threadNames.size() < 2);
    }

    @Test
    public void throttle() {
        int durationMs = 2000;
        LOG.infof("About to sent messages for %d ms", (Object)2000);
        long deadline = System.currentTimeMillis() + 2000L;
        int i = 0;
        HashMap<Integer, AtomicInteger> statusCounts = new HashMap<Integer, AtomicInteger>();
        statusCounts.put(200, new AtomicInteger());
        statusCounts.put(500, new AtomicInteger());
        while (System.currentTimeMillis() < deadline) {
            int status = ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("message-" + i++).post("/eip/route/throttle", new Object[0])).then()).extract().statusCode();
            ((AtomicInteger)statusCounts.get(status)).incrementAndGet();
        }
        int successCount = ((AtomicInteger)statusCounts.get(200)).get();
        int rejectedCount = ((AtomicInteger)statusCounts.get(500)).get();
        LOG.infof("Sent %d messages, sucessful %d, rejected %d", (Object)i, (Object)successCount, (Object)rejectedCount);
        Assertions.assertThat((int)rejectedCount).isGreaterThan(0);
        String[] samples = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/eip/mock/throttle/" + successCount + "+/5000/body"), (Object[])new Object[0]).then()).statusCode(200)).extract().body().asString().split(",");
        LOG.infof("%d messages passed the route", (Object)samples.length);
        Assertions.assertThat((int)samples.length).isEqualTo(successCount);
        Assertions.assertThat((int)successCount).isLessThanOrEqualTo(1000);
    }

    @Test
    public void tryCatchFinally() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("foo").post("/eip/route/tryCatchFinally", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Handled by finally: Hello foo"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("throw").post("/eip/route/tryCatchFinally", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Handled by finally: Caught throw"), new Matcher[0]);
    }

    @Test
    public void expression() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("expressionHeader", new Object[]{"true"}).body("foo").post("/eip/route/expression", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"expressionHeader was true"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("expressionHeader", new Object[]{"false"}).body("foo").post("/eip/route/expression", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"expressionHeader was false"), new Matcher[0]);
    }
}

