/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.eip.it;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ClaimCheckOperation;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.processor.loadbalancer.RoundRobinLoadBalancer;

@ApplicationScoped
public class EipRoutes
extends RouteBuilder {
    public static final int THROTTLE_PERIOD = 500;
    public static final int THROTTLE_MAXIMUM_REQUEST_COUNT = 2;
    public static final int WEIGHTED_1 = 2;
    public static final int WEIGHTED_2 = 1;

    public void configure() {
        ((RouteDefinition)((RouteDefinition)((ProcessorDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((ProcessorDefinition)((RouteDefinition)this.from("direct:claimCheckByHeader").claimCheck(ClaimCheckOperation.Set, "${header.claimCheckId}")).transform().constant((Object)"Bye World")).to("mock:claimCheckByHeader")).claimCheck(ClaimCheckOperation.Get, "${header.claimCheckId}")).to("mock:claimCheckByHeader")).transform().constant((Object)"Hi World")).to("mock:claimCheckByHeader")).claimCheck(ClaimCheckOperation.Get, "${header.claimCheckId}")).to("mock:claimCheckByHeader");
        this.from("direct:customLoadBalancer").loadBalance().custom("roundRobin").to(new String[]{"mock:customLoadBalancer1", "mock:customLoadBalancer2"});
        this.from("direct:roundRobinLoadBalancer").loadBalance().roundRobin().to(new String[]{"mock:roundRobinLoadBalancer1", "mock:roundRobinLoadBalancer2"});
        this.from("direct:stickyLoadBalancer").loadBalance().sticky((Expression)this.header("stickyKey")).to(new String[]{"mock:stickyLoadBalancer1", "mock:stickyLoadBalancer2"});
        this.from("direct:weightedLoadBalancer").loadBalance().weighted(false, "2,1").to(new String[]{"mock:weightedLoadBalancer1", "mock:weightedLoadBalancer2"});
        this.from("direct:enrich").enrich("direct:prepend-hello");
        this.from("direct:prepend-hello").setBody((Expression)this.body().prepend((Object)"Hello "));
        this.from("direct:failover").loadBalance().failover(new Class[]{MyException.class}).to(new String[]{"direct:failover1", "direct:failover2"});
        this.from("direct:failover1").throwException((Exception)new MyException());
        this.from("direct:failover2").setBody((Expression)this.body().prepend((Object)"Hello from failover2 "));
        this.from("direct:loop").loop(3).to("mock:loop");
        this.from("direct:multicast").multicast().parallelProcessing().to(new String[]{"mock:multicast1", "mock:multicast2", "mock:multicast3"});
        this.from("direct:recipientList").recipientList((Expression)this.constant("mock:recipientList1,mock:recipientList2,mock:recipientList3"));
        ((RouteDefinition)this.from("direct:removeHeader").removeHeader("headerToRemove")).to("mock:removeHeader");
        ((RouteDefinition)this.from("direct:removeHeaders").removeHeaders("headerToRemove.*")).to("mock:removeHeaders");
        Processor headersToProperties = e -> e.getMessage().getHeaders().entrySet().stream().filter(en -> ((String)en.getKey()).contains("roperty")).forEach(en -> e.getProperties().put((String)en.getKey(), en.getValue()));
        ((RouteDefinition)((RouteDefinition)this.from("direct:removeProperty").process(headersToProperties)).removeProperty("propertyToRemove")).to("mock:removeProperty");
        ((RouteDefinition)((RouteDefinition)this.from("direct:removeProperties").process(headersToProperties)).removeProperties("propertyToRemove.*")).to("mock:removeProperties");
        this.from("direct:routingSlip").routingSlip((Expression)this.header("routingSlipHeader"));
        this.from("direct:sample").sample().to("mock:sample");
        this.from("direct:step").step("foo").setBody(e -> "Hello " + (String)e.getMessage().getBody(String.class) + " from step!");
        this.from("direct:resequenceStream").resequence((Expression)this.header("seqno")).stream().capacity(4).timeout(3000L).to("mock:resequenceStream");
        this.from("direct:threads").threads(2).setBody(e -> "Hello from thread " + Thread.currentThread().getName());
        this.from("direct:throttle").throttle(2L).timePeriodMillis(500L).rejectExecution(true).to("mock:throttle");
        ((TryDefinition)((TryDefinition)this.from("direct:tryCatchFinally").doTry().process(e -> {
            String body = (String)e.getMessage().getBody(String.class);
            if ("throw".equals(body)) {
                throw new MyException();
            }
            e.getMessage().setBody((Object)("Hello " + body));
        })).doCatch(MyException.class).setBody(e -> "Caught " + (String)e.getMessage().getBody(String.class))).doFinally().setBody(e -> "Handled by finally: " + (String)e.getMessage().getBody(String.class));
        ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:expression").choice().when().expression((Expression)this.header("expressionHeader"))).setBody((Expression)this.constant("expressionHeader was true"))).otherwise().setBody((Expression)this.constant("expressionHeader was false"))).end();
    }

    @Produces
    @Singleton
    @Named(value="roundRobin")
    RoundRobinLoadBalancer roundRobinLoadBalancer() {
        return new RoundRobinLoadBalancer();
    }

    public static class MyException
    extends RuntimeException {
    }
}

