/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.eip.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
class EipTest {
    EipTest() {
    }

    @Test
    public void claimCheckByHeader() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("Secret").queryParam("claimCheckId", new Object[]{"foo"}).post("/eip/route/claimCheckByHeader", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/claimCheckByHeader/4/10000/body", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"Bye World,Secret,Hi World,Secret"), new Matcher[0]);
    }

    @Test
    public void customLoadBalancer() {
        List<String> messages = Arrays.asList("a", "b", "c", "d");
        for (String msg : messages) {
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/eip/route/customLoadBalancer", new Object[0])).then()).statusCode(200);
        }
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/customLoadBalancer1/2/10000/body", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"a,c"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/customLoadBalancer2/2/10000/body", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"b,d"), new Matcher[0]);
    }

    @Test
    public void enrich() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("Franz").post("/eip/route/enrich", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello Franz"), new Matcher[0]);
    }

    @Test
    public void failover() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("Arthur").post("/eip/route/failover", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello from failover2 Arthur"), new Matcher[0]);
    }

    @Test
    public void loop() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("foo").post("/eip/route/loop", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/loop/3/5000/body", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"foo,foo,foo"), new Matcher[0]);
    }

    @Test
    public void multicast() {
        List<String> messages = Arrays.asList("a", "b", "c", "d");
        for (String msg : messages) {
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/eip/route/multicast", new Object[0])).then()).statusCode(200);
        }
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/multicast1/4/5000/body", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"a,b,c,d"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/multicast2/4/5000/body", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"a,b,c,d"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/multicast3/4/5000/body", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"a,b,c,d"), new Matcher[0]);
    }

    @Test
    public void recipientList() {
        List<String> messages = Arrays.asList("a", "b", "c", "d");
        for (String msg : messages) {
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/eip/route/recipientList", new Object[0])).then()).statusCode(200);
        }
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/recipientList1/4/5000/body", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"a,b,c,d"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/recipientList2/4/5000/body", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"a,b,c,d"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/recipientList3/4/5000/body", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"a,b,c,d"), new Matcher[0]);
    }

    @Test
    public void removeHeader() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("baz").queryParam("headerToKeep", new Object[]{"foo"}).queryParam("headerToRemove", new Object[]{"bar"}).post("/eip/route/removeHeader", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/removeHeader/1/5000/header", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.allOf((Matcher)Matchers.containsString((String)"headerToKeep=foo"), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"headerToRemove"))), new Matcher[0]);
    }

    @Test
    public void removeHeaders() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("baz").queryParam("headerToKeep", new Object[]{"keepFoo"}).queryParam("headerToRemove1", new Object[]{"bar1"}).queryParam("headerToRemove2", new Object[]{"bar2"}).post("/eip/route/removeHeaders", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/removeHeaders/1/5000/header", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.allOf((Matcher)Matchers.containsString((String)"headerToKeep=keepFoo"), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"headerToRemove1")), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"headerToRemove2"))), new Matcher[0]);
    }

    @Test
    public void removeProperty() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("baz").queryParam("propertyToKeep", new Object[]{"keep"}).queryParam("propertyToRemove", new Object[]{"bar"}).post("/eip/route/removeProperty", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/removeProperty/1/5000/property", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.allOf((Matcher)Matchers.containsString((String)"propertyToKeep=keep"), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"propertyToRemove"))), new Matcher[0]);
    }

    @Test
    public void removeProperties() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("baz").queryParam("propertyToKeep", new Object[]{"keepProp"}).queryParam("propertyToRemove1", new Object[]{"bar1"}).queryParam("propertyToRemove2", new Object[]{"bar2"}).post("/eip/route/removeProperties", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/eip/mock/removeProperties/1/5000/property", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.allOf((Matcher)Matchers.containsString((String)"propertyToKeep=keepProp"), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"propertyToRemove1")), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"propertyToRemove2"))), new Matcher[0]);
    }
}

