/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.dsl.modeline.it;

import jakarta.enterprise.event.Observes;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.event.CamelContextStartedEvent;
import org.apache.camel.spi.ModelineFactory;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.ResourceHelper;

@Path(value="/dsl-modeline")
public class DslModelineResource {
    private List<String> deps;
    private ModelineFactory factory;
    private CamelContext context;

    public void onContextStart(@Observes CamelContextStartedEvent event) {
        this.context = event.getContext();
        this.deps = new ArrayList<String>();
        this.context.getRegistry().bind("myDep", dependency -> this.deps.add(dependency));
        this.factory = PluginHelper.getModelineFactory((CamelContext)this.context);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response parseModeline(String line) throws Exception {
        this.factory.parseModeline(ResourceHelper.fromString(null, (String)line));
        return Response.ok().build();
    }

    @Path(value="deps")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<String> getDependencies() {
        return this.deps;
    }

    @Path(value="props/{property}")
    @GET
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String getDependencies(@PathParam(value="property") String property) {
        String uri = String.format("{{%s}}", property);
        return this.context.getPropertiesComponent().parseUri(uri);
    }

    @DELETE
    public Response clear() {
        this.deps.clear();
        return Response.ok().build();
    }
}

