/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.dsl.modeline.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.common.mapper.TypeRef;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class DslModelineTest {
    @Test
    void testModelineSingleDependency() {
        String line = "// camel-k: dependency=mvn:org.my:application:1.0";
        List response = this.parseAndGetDependencies(line);
        Assertions.assertNotNull(response);
        Assertions.assertEquals((int)1, (int)response.size());
        Assertions.assertTrue((boolean)response.contains("mvn:org.my:application:1.0"));
    }

    @Test
    void testModelineSingleDependencyCommentHash() {
        String line = "### camel-k: dependency=mvn:org.my:application:1.0";
        List response = this.parseAndGetDependencies(line);
        Assertions.assertNotNull(response);
        Assertions.assertEquals((int)1, (int)response.size());
        Assertions.assertTrue((boolean)response.contains("mvn:org.my:application:1.0"));
    }

    @Test
    void testModelineMultiDependency() {
        String line = "// camel-k: dependency=mvn:org.my:application:1.0 dependency=mvn:com.foo:myapp:2.1";
        List response = this.parseAndGetDependencies(line);
        Assertions.assertNotNull(response);
        Assertions.assertEquals((int)2, (int)response.size());
        Assertions.assertTrue((boolean)response.contains("mvn:org.my:application:1.0"));
        Assertions.assertTrue((boolean)response.contains("mvn:com.foo:myapp:2.1"));
    }

    @Test
    void testModelineSingleProperty() throws Exception {
        String line = "// camel-k: property=hi=Hello";
        this.clear();
        this.parseModeline(line);
        ((ValidatableResponse)RestAssured.get((String)"/dsl-modeline/props/hi", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"Hello"), new Matcher[0]);
    }

    @Test
    void testModelineMultiProperty() throws Exception {
        String line = "// camel-k: property=hi=Hello property=bye=Farvel";
        this.parseModeline(line);
        ((ValidatableResponse)RestAssured.get((String)"/dsl-modeline/props/hi", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"Hello"), new Matcher[0]);
        ((ValidatableResponse)RestAssured.get((String)"/dsl-modeline/props/bye", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"Farvel"), new Matcher[0]);
    }

    @Test
    void testModelineQuoteProperty() throws Exception {
        String line = "// camel-k: property=hi='Hello World' property=bye='Farvel Verden'";
        this.parseModeline(line);
        ((ValidatableResponse)RestAssured.get((String)"/dsl-modeline/props/hi", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"Hello World"), new Matcher[0]);
        ((ValidatableResponse)RestAssured.get((String)"/dsl-modeline/props/bye", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"Farvel Verden"), new Matcher[0]);
    }

    @Test
    void testModelineMixed() throws Exception {
        String line = "// camel-k: dependency=mvn:org.my:application:1.0 property=hi=Hello dependency=mvn:com.foo:myapp:2.1";
        List response = this.parseAndGetDependencies(line);
        Assertions.assertNotNull(response);
        Assertions.assertEquals((int)2, (int)response.size());
        Assertions.assertTrue((boolean)response.contains("mvn:org.my:application:1.0"));
        Assertions.assertTrue((boolean)response.contains("mvn:com.foo:myapp:2.1"));
        ((ValidatableResponse)RestAssured.get((String)"/dsl-modeline/props/hi", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"Hello"), new Matcher[0]);
    }

    @Test
    void testModelineMixedWithSpaces() throws Exception {
        String line = "//    camel-k:   dependency=mvn:org.my:application:1.0    property=hi=Hello   dependency=mvn:com.foo:myapp:2.1";
        List response = this.parseAndGetDependencies(line);
        Assertions.assertNotNull(response);
        Assertions.assertEquals((int)2, (int)response.size());
        Assertions.assertTrue((boolean)response.contains("mvn:org.my:application:1.0"));
        Assertions.assertTrue((boolean)response.contains("mvn:com.foo:myapp:2.1"));
        ((ValidatableResponse)RestAssured.get((String)"/dsl-modeline/props/hi", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"Hello"), new Matcher[0]);
    }

    @Test
    void testModelinePropertiesFile() throws Exception {
        String line = "// camel-k: property=classpath:myapp.properties";
        this.parseModeline(line);
        ((ValidatableResponse)RestAssured.get((String)"/dsl-modeline/props/hi", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"Hej"), new Matcher[0]);
        ((ValidatableResponse)RestAssured.get((String)"/dsl-modeline/props/foo", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"bar"), new Matcher[0]);
    }

    private <T> List<T> parseAndGetDependencies(String line) {
        this.clear();
        this.parseModeline(line);
        return (List)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().body(line).get("/dsl-modeline/deps", new Object[0])).then()).extract().body().as(new TypeRef<List<T>>(){});
    }

    private void clear() {
        ((ValidatableResponse)RestAssured.delete((String)"/dsl-modeline", (Object[])new Object[0]).then()).statusCode(200);
    }

    private void parseModeline(String line) {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().body(line).post("/dsl-modeline", new Object[0])).then()).statusCode(200);
    }
}

