/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.dropbox.it;

import com.dropbox.core.v2.files.DownloadErrorException;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ProducerTemplate;

@Path(value="/dropbox")
public class DropboxResource {
    public static final String REMOTE_PATH = "/camel/quarkus/";
    public static final String FILE_NAME = "test.txt";
    public static final String FILE_CONTENT = "Hello Camel Quarkus DropBox";
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/create")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response createFile() throws Exception {
        java.nio.file.Path path = Files.write(Paths.get("target", FILE_NAME), FILE_CONTENT.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        String result = (String)this.producerTemplate.requestBodyAndHeader("dropbox://put?" + this.getCredentialsUriOptions() + "&uploadMode=add&localPath=" + String.valueOf(path) + "&remotePath=/camel/quarkus/", null, "CamelDropboxPutFileName", (Object)FILE_NAME, String.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)result).build();
    }

    @Path(value="/read")
    @GET
    @Produces(value={"text/plain"})
    public Response readFile() {
        try {
            String content = (String)this.producerTemplate.requestBody("dropbox://get?" + this.getCredentialsUriOptions() + "&remotePath=/camel/quarkus/test.txt", null, String.class);
            if (content != null) {
                return Response.ok((Object)content).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (CamelExecutionException e) {
            Exception exchangeException = e.getExchange().getException();
            if (exchangeException != null && exchangeException.getCause() instanceof DownloadErrorException) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            throw e;
        }
    }

    @Path(value="/delete")
    @DELETE
    public Response deleteFile() {
        this.producerTemplate.requestBody("dropbox://del?" + this.getCredentialsUriOptions() + "&remotePath=/camel/quarkus/test.txt", null);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    private String getCredentialsUriOptions() {
        return "accessToken={{DROPBOX_ACCESS_TOKEN}}&clientIdentifier={{DROPBOX_CLIENT_IDENTIFIER}}&refreshToken={{DROPBOX_REFRESH_TOKEN}}&apiKey={{DROPBOX_API_KEY}}&apiSecret={{DROPBOX_API_SECRET}}&expireIn={{DROPBOX_ACCESS_TOKEN_EXPIRES_IN}}";
    }
}

