/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.dozer.it;

import java.util.HashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.quarkus.component.dozer.it.model.CustomerA;
import org.apache.camel.quarkus.component.dozer.it.model.CustomerB;

@Path(value="/dozer")
@ApplicationScoped
public class DozerResource {
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/map")
    @GET
    @Produces(value={"application/json"})
    public CustomerB dozerMap() {
        return (CustomerB)this.producerTemplate.requestBody("direct:mapWithEndpoint", (Object)this.createCustomerA(), CustomerB.class);
    }

    @Path(value="/map/using/converter")
    @GET
    @Produces(value={"application/json"})
    public CustomerB dozerMapWithConverter() {
        return (CustomerB)this.producerTemplate.requestBody("direct:mapWithConverter", (Object)this.createCustomerA(), CustomerB.class);
    }

    @Path(value="/map/using/variable")
    @GET
    @Produces(value={"application/json"})
    public CustomerB dozerMapWithVariable() {
        return (CustomerB)this.producerTemplate.requestBody("direct:mapWithVariable", (Object)this.createCustomerA(), CustomerB.class);
    }

    @Path(value="/map/using/expression")
    @GET
    @Produces(value={"application/json"})
    public CustomerB dozerMapWithExpression() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("firstName", "Camel");
        headers.put("lastName", "Quarkus");
        return (CustomerB)this.producerTemplate.requestBodyAndHeaders("direct:mapWithExpression", (Object)this.createCustomerA(), headers, CustomerB.class);
    }

    private CustomerA createCustomerA() {
        return new CustomerA("Peter", "Post", "Camel Street", "12345");
    }
}

