/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.disruptor.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
class DisruptorTest {
    DisruptorTest() {
    }

    @Test
    public void loadComponent() {
        ((ValidatableResponse)RestAssured.get((String)"/disruptor/component/{componentName}", (Object[])new Object[]{"disruptor"}).then()).statusCode(200);
        ((ValidatableResponse)RestAssured.get((String)"/disruptor/component/{componentName}", (Object[])new Object[]{"disruptor-vm"}).then()).statusCode(404);
    }

    @Test
    public void putAndTake() {
        String id = "the-id";
        String value = UUID.randomUUID().toString();
        ((ValidatableResponse)((Response)RestAssured.given().body(value).post("/disruptor/buffer/{name}", new Object[]{"the-id"})).then()).statusCode(204);
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> {
            int count = (Integer)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept("application/json").when().get("/disruptor/buffer/{name}/inspect", new Object[]{"the-id"})).then()).statusCode(200)).extract().path("pendingExchangeCount", new String[0]);
            return count == 1;
        });
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/disruptor/buffer/{name}", (Object[])new Object[]{"the-id"}).then()).statusCode(200)).body(Matchers.is((Object)value), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept("application/json").when().get("/disruptor/buffer/{name}/inspect", new Object[]{"the-id"})).then()).statusCode(200)).body("pendingExchangeCount", Matchers.is((Object)0), new Object[]{"size", Matchers.is((Object)0)});
    }
}

