/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.direct.it;

import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.TemplatedRouteBuilder;
import org.apache.camel.catalog.RuntimeCamelCatalog;
import org.apache.camel.quarkus.core.CamelRuntimeCatalog;

@ApplicationScoped
@Path(value="/direct")
public class DirectResource {
    @Inject
    CamelContext context;
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/routes/template/{id}/{greeting}")
    @GET
    @Produces(value={"text/plain"})
    public String routeTemplate(@PathParam(value="id") String id, @PathParam(value="greeting") String greeting) {
        String uuid = this.context.getUuidGenerator().generateUuid();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)id).routeId(uuid).parameter("uuid", (Object)uuid).parameter("greeting", (Object)greeting).add();
        return (String)this.context.createFluentProducerTemplate().toF("direct:%s", new Object[]{uuid}).request(String.class);
    }

    @Path(value="/catalog/{type}/{name}")
    @GET
    @Produces(value={"application/json"})
    public Response catalog(@PathParam(value="type") String type, @PathParam(value="name") String name) throws IOException {
        CamelRuntimeCatalog catalog = (CamelRuntimeCatalog)this.context.getExtension(RuntimeCamelCatalog.class);
        try {
            String schema;
            switch (type) {
                case "component": {
                    schema = catalog.componentJSonSchema(name);
                    break;
                }
                case "language": {
                    schema = catalog.languageJSonSchema(name);
                    break;
                }
                case "dataformat": {
                    schema = catalog.dataFormatJSonSchema(name);
                    break;
                }
                case "model": {
                    schema = catalog.modelJSonSchema(name);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type " + type);
                }
            }
            return Response.ok((Object)schema).build();
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)(e.getClass().getSimpleName() + ": " + e.getMessage())).build();
        }
    }

    @Path(value="/route/{route}")
    @POST
    public void route(@PathParam(value="route") String route, String message) {
        this.producerTemplate.sendBody("direct:" + route, (Object)message);
    }
}

