/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.direct.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class DirectTest {
    @Test
    public void catalogComponent() throws IOException {
        ((ValidatableResponse)((Response)RestAssured.when().get("/direct/catalog/component/direct", new Object[0])).then()).body(IsNot.not((Matcher)Matchers.emptyOrNullString()), new Matcher[0]);
    }

    @Test
    public void routeTemplate() {
        ((ValidatableResponse)((Response)RestAssured.when().get("/direct/routes/template/myTemplate/World", new Object[0])).then()).body(Matchers.is((Object)"Hello World"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.when().get("/direct/routes/template/myTemplate/Earth", new Object[0])).then()).body(Matchers.is((Object)"Hello Earth"), new Matcher[0]);
    }

    @Test
    public void directConsumerProducer() {
        String message1 = UUID.randomUUID().toString();
        String message2 = UUID.randomUUID().toString();
        ((ValidatableResponse)((Response)RestAssured.given().body(message1).post("/direct/route/to-logger", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((Response)RestAssured.given().body(message2).post("/direct/route/consumer-producer", new Object[0])).then()).statusCode(204);
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).pollDelay(100L, TimeUnit.MILLISECONDS).until(() -> {
            String log = new String(Files.readAllBytes(Paths.get("target/quarkus.log", new String[0])), StandardCharsets.UTF_8);
            return log.contains(message1) && log.contains(message2);
        });
    }
}

