/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.digitalocean.it;

import com.github.tomakehurst.wiremock.WireMockServer;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.quarkus.component.digitalocean.it.DigitaloceanTestResource;
import org.apache.camel.quarkus.test.wiremock.MockServer;
import org.eclipse.microprofile.config.ConfigProvider;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=DigitaloceanTestResource.class)
class DigitaloceanTest {
    static String publicKey;
    @MockServer
    WireMockServer server;

    DigitaloceanTest() {
    }

    @BeforeAll
    public static void initPublicKey() {
        publicKey = ConfigProvider.getConfig().getOptionalValue("DIGITALOCEAN_PUBLIC_KEY", String.class).orElse("ssh-rsa AEXAMPLEaC1yc2EAAAADAQABAAAAQQDDHr/jh2Jy4yALcK4JyWbVkPRaWmhck3IgCoeOO3z1e2dBowLh64QAM+Qb72pxekALga2oi4GvT+TlWNhzPH4V example");
    }

    @Test
    void testAccount() {
        ((ValidatableResponse)((Response)RestAssured.given().when().get("/digitalocean/account/", new Object[0])).then()).body("uuid", Matchers.notNullValue(), new Object[0]);
    }

    @Test
    void testSizes() {
        List sizes = (List)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).get("/digitalocean/sizes", new Object[0])).then()).extract().body().as(List.class);
        Assertions.assertNotNull((Object)sizes);
        Optional<Map> size_1Gb = sizes.stream().filter(s -> "s-1vcpu-1gb".equals(s.get("slug"))).findFirst();
        Assertions.assertTrue((boolean)size_1Gb.isPresent());
    }

    @Test
    void testRegions() {
        List regions = (List)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).get("/digitalocean/regions", new Object[0])).then()).extract().body().as(List.class);
        Assertions.assertNotNull((Object)regions);
        Optional<Map> nyc1Region = regions.stream().filter(r -> "nyc1".equals(r.get("slug"))).findFirst();
        Assertions.assertTrue((boolean)nyc1Region.isPresent());
    }

    @Test
    void testKeys() {
        String name = "TestKey1";
        Integer publicKeyId = (Integer)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(publicKey).put("/digitalocean/keys/" + name, new Object[0])).then()).extract().body().as(Integer.class);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).get("/digitalocean/keys/" + publicKeyId, new Object[0])).then()).body("id", Matchers.equalTo((Object)publicKeyId), new Object[0])).body("name", Matchers.equalTo((Object)name), new Object[0]);
        name = "updated_TestKey1";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(name).post("/digitalocean/keys/" + publicKeyId, new Object[0])).then()).body("id", Matchers.equalTo((Object)publicKeyId), new Object[0])).body("name", Matchers.equalTo((Object)name), new Object[0]);
        List keys = (List)((ValidatableResponse)((Response)RestAssured.given().get("/digitalocean/keys", new Object[0])).then()).extract().body().as(List.class);
        Optional<Map> resultKey = keys.stream().filter(m -> publicKeyId.equals(m.get("id"))).findAny();
        Assertions.assertTrue((boolean)resultKey.isPresent());
        ((ValidatableResponse)((Response)RestAssured.given().delete("/digitalocean/keys/" + publicKeyId, new Object[0])).then()).body("isRequestSuccess", CoreMatchers.equalTo((Object)true), new Object[0]);
    }

    @Test
    void testTags() {
        String name = "awesome";
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).post("/digitalocean/tags/" + name, new Object[0])).then()).body("name", Matchers.equalTo((Object)name), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().get("/digitalocean/tags/" + name, new Object[0])).then()).body("name", Matchers.equalTo((Object)name), new Object[0]);
        List tags = (List)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).get("/digitalocean/tags/", new Object[0])).then()).extract().body().as(List.class);
        Optional<Map> resultKey = tags.stream().filter(t -> name.equals(t.get("name"))).findAny();
        Assertions.assertTrue((boolean)resultKey.isPresent());
        ((ValidatableResponse)((Response)RestAssured.given().delete("/digitalocean/tags/" + name, new Object[0])).then()).body("isRequestSuccess", CoreMatchers.equalTo((Object)true), new Object[0]);
    }
}

