/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.digitalocean.it;

import com.github.tomakehurst.wiremock.WireMockServer;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.camel.quarkus.component.digitalocean.it.DigitaloceanTestResource;
import org.apache.camel.quarkus.test.wiremock.MockServer;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.config.ConfigProvider;
import org.hamcrest.CoreMatchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=DigitaloceanTestResource.class)
public class DigitaloceanDropletTest {
    static final long timeout = 5L;
    static TimeUnit timeoutUnit = TimeUnit.SECONDS;
    static boolean waitBlockStorageAction = false;
    @MockServer
    WireMockServer server;

    @BeforeAll
    public static void initTimeoutUnit() {
        Optional key = ConfigProvider.getConfig().getOptionalValue("DIGITALOCEAN_AUTH_TOKEN", String.class);
        if (key.isPresent()) {
            timeoutUnit = TimeUnit.MINUTES;
            waitBlockStorageAction = true;
        }
    }

    @Test
    void testDroplets() throws InterruptedException {
        Integer dropletId = (Integer)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).put("/digitalocean/droplet/droplet1", new Object[0])).then()).extract().body().as(Integer.class);
        Assertions.assertNotNull((Object)dropletId);
        this.waitActiveDroplet(dropletId);
        this.performActions(dropletId);
        this.testResultActions(dropletId);
        this.testNeighbors(dropletId);
        this.testFloatingIP(dropletId);
        this.testImages();
        this.testSnapshots();
        this.testBlockStorages(dropletId);
        ((ValidatableResponse)((Response)RestAssured.given().when().delete("/digitalocean/droplet/" + dropletId, new Object[0])).then()).statusCode(202);
    }

    private void performActions(Integer dropletId) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).get("/digitalocean/droplet/backups/enable/" + dropletId, new Object[0])).then()).body("resourceId", CoreMatchers.equalTo((Object)dropletId), new Object[0])).body("type", CoreMatchers.equalTo((Object)"ENABLE_BACKUPS"), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).get("/digitalocean/droplet/off/" + dropletId, new Object[0])).then()).body("resourceId", CoreMatchers.equalTo((Object)dropletId), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("snapshot1").post("/digitalocean/droplet/snapshot/" + dropletId, new Object[0])).then()).body("resourceId", CoreMatchers.equalTo((Object)dropletId), new Object[0]);
        this.waitForSnapshot(dropletId);
        ((ValidatableResponse)((Response)RestAssured.given().when().get("/digitalocean/droplet/backups/disable/" + dropletId, new Object[0])).then()).body("resourceId", CoreMatchers.equalTo((Object)dropletId), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).get("/digitalocean/droplet/on/" + dropletId, new Object[0])).then()).body("resourceId", CoreMatchers.equalTo((Object)dropletId), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).get("/digitalocean/droplet/reboot/" + dropletId, new Object[0])).then()).body("resourceId", CoreMatchers.equalTo((Object)dropletId), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).get("/digitalocean/droplet/ipv6/" + dropletId, new Object[0])).then()).body("resourceId", CoreMatchers.equalTo((Object)dropletId), new Object[0]);
    }

    private void testResultActions(Integer dropletId) {
        List actions = (List)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).get("/digitalocean/droplet/actions/" + dropletId, new Object[0])).then()).extract().body().as(List.class);
        List<String> types = Arrays.asList("ENABLE_BACKUPS", "DISABLE_BACKUPS", "SNAPSHOT", "POWER_ON", "POWER_OFF", "REBOOT", "ENABLE_IPV6");
        this.assertActions(actions, types);
        Integer snapshotActionId = this.getSnapshotActionId(actions);
        ((ValidatableResponse)((Response)RestAssured.given().get("/digitalocean/action/" + snapshotActionId, new Object[0])).then()).body("id", CoreMatchers.equalTo((Object)snapshotActionId), new Object[0]);
        actions = (List)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).get("/digitalocean/actions/", new Object[0])).then()).extract().body().as(List.class);
        types = Arrays.asList("ENABLE_BACKUPS", "DISABLE_BACKUPS", "SNAPSHOT", "POWER_ON", "POWER_OFF", "REBOOT");
        this.assertActions(actions, types);
    }

    private void waitForSnapshot(Integer dropletId) {
        Awaitility.await().atMost(5L, timeoutUnit).until(() -> {
            String path = "/digitalocean/droplet/snapshots/" + dropletId;
            List result = (List)((ValidatableResponse)((Response)RestAssured.given().when().get(path, new Object[0])).then()).extract().as(List.class);
            Optional<Map> optional = result.stream().filter(s -> "snapshot1".equals(s.get("name"))).findAny();
            return optional.isPresent();
        });
    }

    private void waitActiveDroplet(Integer dropletId) {
        Awaitility.await().atMost(5L, timeoutUnit).until(() -> {
            String path = "/digitalocean/droplet/" + dropletId;
            Map droplet = (Map)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).get(path, new Object[0])).then()).extract().as(Map.class);
            return droplet != null && dropletId.equals(droplet.get("id")) && "ACTIVE".equals(droplet.get("status"));
        });
    }

    private void assertActions(List<Map<String, Object>> actions, List<String> types) {
        Assertions.assertNotNull(actions);
        Assertions.assertTrue((actions.size() >= types.size() ? 1 : 0) != 0);
        types.forEach(type -> this.assertAction(actions, (String)type));
    }

    private void assertAction(List<Map<String, Object>> actions, String actionType) {
        Optional<Map> optional = actions.stream().filter(a -> actionType.equals(a.get("type"))).findAny();
        Assertions.assertTrue((boolean)optional.isPresent());
    }

    private Integer getSnapshotActionId(List<Map<String, Object>> actions) {
        return actions.stream().filter(a -> "SNAPSHOT".equals(a.get("type"))).findAny().map(b -> (Integer)b.get("id")).orElse(null);
    }

    private void testNeighbors(int dropletId) {
        ((ValidatableResponse)((Response)RestAssured.given().when().get("/digitalocean/droplet/neighbors/" + dropletId, new Object[0])).then()).statusCode(200);
    }

    private void testImages() {
        List images = (List)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).get("/digitalocean/images", new Object[0])).then()).extract().body().as(List.class);
        Assertions.assertNotNull((Object)images);
        Integer imageId = images.stream().findAny().map(image -> (Integer)image.get("id")).orElse(null);
        Assertions.assertNotNull((Object)imageId);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).get("/digitalocean/images/" + imageId, new Object[0])).then()).body("id", CoreMatchers.equalTo((Object)imageId), new Object[0]);
        images = (List)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).get("/digitalocean/images/user", new Object[0])).then()).extract().body().as(List.class);
        Assertions.assertNotNull((Object)images);
    }

    private void testSnapshots() {
        List images = (List)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).get("/digitalocean/snapshots", new Object[0])).then()).extract().body().as(List.class);
        Assertions.assertNotNull((Object)images);
        Integer snapshotId = images.stream().findAny().map(snapshot -> (Integer)snapshot.get("id")).orElse(null);
        Assertions.assertNotNull((Object)snapshotId);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).get("/digitalocean/snapshots/" + snapshotId, new Object[0])).then()).body("id", CoreMatchers.equalTo((Object)snapshotId), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).delete("/digitalocean/snapshots/" + snapshotId, new Object[0])).then()).statusCode(200);
    }

    private void testFloatingIP(Integer dropletId) {
        AtomicReference floatingIp = new AtomicReference();
        Awaitility.await().atMost(5L, timeoutUnit).until(() -> {
            floatingIp.set(((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)dropletId).put("/digitalocean/floatingIP", new Object[0])).then()).extract().body().asString());
            return !((String)floatingIp.get()).equals("");
        });
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).get("/digitalocean/floatingIP/" + floatingIp, new Object[0])).then()).body("ip", CoreMatchers.equalTo((Object)((String)floatingIp.get())), new Object[0]);
        List floatingIps = (List)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).get("/digitalocean/floatingIP", new Object[0])).then()).extract().body().as(List.class);
        Optional<Map> floatingIpResult = floatingIps.stream().filter(f -> ((String)floatingIp.get()).equals(f.get("ip"))).findAny();
        Assertions.assertTrue((boolean)floatingIpResult.isPresent());
        Map[] action = new Map[1];
        Awaitility.await().atMost(5L, timeoutUnit).until(() -> {
            action[0] = (Map)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).get("/digitalocean/floatingIP/unassign/" + floatingIp, new Object[0])).then()).extract().body().as(Map.class);
            return action[0] != null && "UNASSIGN_FLOATING_IP".equals(action[0].get("type"));
        });
        Integer actionId = (Integer)action[0].get("id");
        List actions = (List)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).get("/digitalocean/floatingIP/actions/" + floatingIp, new Object[0])).then()).extract().body().as(List.class);
        Assertions.assertNotNull((Object)actions);
        Optional<Map> actionUnassign = actions.stream().filter(a -> actionId.equals(a.get("id"))).findAny();
        Assertions.assertTrue((boolean)actionUnassign.isPresent());
        Awaitility.await().atMost(5L, timeoutUnit).until(() -> {
            Map delete = (Map)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).delete("/digitalocean/floatingIP/" + floatingIp, new Object[0])).then()).extract().body().as(Map.class);
            return delete != null && (Boolean)delete.get("isRequestSuccess") != false;
        });
    }

    private void testBlockStorages(Integer dropletId) throws InterruptedException {
        String volumeId = ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("volume1").when().put("/digitalocean/blockStorages", new Object[0])).then()).extract().body().asString();
        Assertions.assertNotNull((Object)volumeId);
        ((ValidatableResponse)((Response)RestAssured.given().get("/digitalocean/blockStorages/" + volumeId, new Object[0])).then()).body("name", CoreMatchers.equalTo((Object)"volume1"), new Object[0]);
        List volumes = (List)((ValidatableResponse)((Response)RestAssured.given().get("/digitalocean/blockStorages", new Object[0])).then()).extract().body().as(List.class);
        Assertions.assertNotNull((Object)volumes);
        Map expectedResult = volumes.stream().filter(v -> "volume1".equals(v.get("name"))).findAny().orElse(null);
        Assertions.assertNotNull((Object)expectedResult);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)dropletId).when().post("/digitalocean/blockStorages/attach/volume1", new Object[0])).then()).body("type", CoreMatchers.equalTo((Object)"ATTACH"), new Object[0]);
        this.waitAttachedVolume(dropletId, volumeId);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)dropletId).when().post("/digitalocean/blockStorages/detach/volume1", new Object[0])).then()).statusCode(200);
        if (waitBlockStorageAction) {
            Thread.sleep(10000L);
        }
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(volumeId).when().delete("/digitalocean/blockStorages", new Object[0])).then()).body("isRequestSuccess", CoreMatchers.equalTo((Object)true), new Object[0]);
    }

    private void waitAttachedVolume(Integer dropletId, String volumeId) {
        Awaitility.await().atMost(5L, timeoutUnit).until(() -> {
            String path = "/digitalocean/droplet/" + dropletId;
            Map droplet = (Map)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).get(path, new Object[0])).then()).extract().as(Map.class);
            return droplet.get("volumeIds") != null && ((List)droplet.get("volumeIds")).contains(volumeId);
        });
    }
}

