/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.debug.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.camel.ServiceStatus;
import org.apache.camel.api.management.mbean.ManagedBacklogDebuggerMBean;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class DebugTest {
    @Test
    public void camelDebuggingEnabled() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/debug/enabled", (Object[])new Object[0]).then()).body(Matchers.is((Object)"true"), new Matcher[0])).statusCode(200);
    }

    @Test
    void camelDebugJmxConnection() throws Exception {
        String url = String.format("service:jmx:rmi:///jndi/rmi://%s:%d%s", "localhost", 1099, "/jmxrmi/camel");
        JMXServiceURL jmxUrl = new JMXServiceURL(url);
        Awaitility.await().pollInterval(50L, TimeUnit.MILLISECONDS).atMost(10L, TimeUnit.SECONDS).untilAsserted(() -> {
            try (JMXConnector connector = JMXConnectorFactory.connect(jmxUrl);){
                MBeanServerConnection mbeanServer = connector.getMBeanServerConnection();
                ObjectName objectName = new ObjectName("org.apache.camel:type=context,*");
                Set<ObjectInstance> mbeans = mbeanServer.queryMBeans(objectName, null);
                Assertions.assertNotNull(mbeans);
                Iterator<ObjectInstance> iterator = mbeans.iterator();
                if (iterator.hasNext()) {
                    ObjectInstance camelContext = iterator.next();
                    Assertions.assertNotNull((Object)camelContext);
                    String status = (String)mbeanServer.invoke(camelContext.getObjectName(), "getState", new Object[0], new String[0]);
                    Assertions.assertEquals((Object)ServiceStatus.Started, (Object)ServiceStatus.valueOf((String)status));
                } else {
                    Assertions.fail((String)"Expected to find 1 CamelContext MBean");
                }
            }
        });
    }

    @Test
    void accessToBacklogDebugger() throws Exception {
        String url = String.format("service:jmx:rmi:///jndi/rmi://%s:%d%s", "localhost", 1099, "/jmxrmi/camel");
        JMXServiceURL jmxUrl = new JMXServiceURL(url);
        Awaitility.await().pollInterval(50L, TimeUnit.MILLISECONDS).atMost(10L, TimeUnit.SECONDS).untilAsserted(() -> {
            try (JMXConnector connector = JMXConnectorFactory.connect(jmxUrl);){
                MBeanServerConnection mbeanServer = connector.getMBeanServerConnection();
                ObjectName objectName = new ObjectName("org.apache.camel:context=*,type=tracer,name=BacklogDebugger");
                Set<ObjectName> names = mbeanServer.queryNames(objectName, null);
                Assertions.assertNotNull(names);
                Iterator<ObjectName> iteratorNames = names.iterator();
                if (iteratorNames.hasNext()) {
                    ObjectName debuggerMBeanObjectName = iteratorNames.next();
                    Assertions.assertNotNull((Object)debuggerMBeanObjectName);
                    ManagedBacklogDebuggerMBean backlogDebugger = JMX.newMBeanProxy(mbeanServer, debuggerMBeanObjectName, ManagedBacklogDebuggerMBean.class);
                    Set breakpoints = backlogDebugger.breakpoints();
                    Assertions.assertNotNull((Object)breakpoints);
                    Set suspendedBreakpointNodeIds = backlogDebugger.suspendedBreakpointNodeIds();
                    Assertions.assertNotNull((Object)suspendedBreakpointNodeIds);
                } else {
                    Assertions.fail((String)"Expected to find 1 BacklogDebugger");
                }
            }
        });
    }
}

