/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.datasonnet.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.TimeZone;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.quarkus.component.datasonnet.model.Gizmo;
import org.apache.camel.quarkus.component.datasonnet.model.Manufacturer;
import org.jboss.logging.Logger;

@Path(value="/datasonnet")
@ApplicationScoped
public class DatasonnetResource {
    private static final Logger LOG = Logger.getLogger(DatasonnetResource.class);
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;

    @Path(value="/basicTransform")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response basicTransform(String message) throws Exception {
        LOG.infof("Sending to datasonnet: %s", (Object)message);
        String response = (String)this.producerTemplate.requestBody("direct:basicTransform", (Object)message, String.class);
        LOG.infof("Got response from datasonnet: %s", (Object)response);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
    }

    @Path(value="/transformXML")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/json"})
    public Response transformXML(String message) throws Exception {
        LOG.infof("Sending to datasonnet: %s", (Object)message);
        String response = (String)this.producerTemplate.requestBody("direct:transformXML", (Object)message, String.class);
        LOG.infof("Got response from datasonnet: %s", (Object)response);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
    }

    @Path(value="/transformCSV")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public Response transformCSV(String message) throws Exception {
        LOG.infof("Sending to datasonnet: %s", (Object)message);
        String response = (String)this.producerTemplate.requestBody("direct:transformCSV", (Object)message, String.class);
        LOG.infof("Got response from datasonnet: %s", (Object)response);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
    }

    @Path(value="/namedImports")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response namedImports(String message) throws Exception {
        LOG.infof("Sending to datasonnet: %s", (Object)message);
        String response = (String)this.producerTemplate.requestBody("direct:namedImports", (Object)message, String.class);
        LOG.infof("Got response from datasonnet: %s", (Object)response);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
    }

    @Path(value="/expressionLanguage")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public Response expressionLanguage(String message) throws Exception {
        LOG.infof("Sending to datasonnet: %s", (Object)message);
        String response = (String)this.producerTemplate.requestBody("direct:expressionLanguage", (Object)message, String.class);
        LOG.infof("Got response from datasonnet: %s", (Object)response);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
    }

    @Path(value="/nullInput")
    @POST
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    public Response nullInput(String message) throws Exception {
        LOG.infof("Sending to datasonnet: %s", (Object)message);
        String response = (String)this.producerTemplate.requestBody("direct:nullInput", (Object)message, String.class);
        LOG.infof("Got response from datasonnet: %s", (Object)response);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
    }

    @Path(value="/readJava")
    @POST
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    public Response readJava(String message) throws Exception {
        Gizmo theGizmo = new Gizmo();
        theGizmo.setName("gizmo");
        theGizmo.setQuantity(123);
        theGizmo.setInStock(true);
        theGizmo.setColors(Arrays.asList("red", "white", "blue"));
        Manufacturer manufacturer = new Manufacturer();
        manufacturer.setManufacturerName("ACME Corp.");
        manufacturer.setManufacturerCode("ACME123");
        theGizmo.setManufacturer(manufacturer);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        theGizmo.setDate(df.parse("2020-01-06"));
        LOG.infof("Sending to datasonnet: %s", (Object)theGizmo);
        String response = (String)this.producerTemplate.requestBody("direct:readJava", (Object)theGizmo, String.class);
        LOG.infof("Got response from datasonnet: %s", (Object)response);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
    }

    @Path(value="/readJavaDatasonnetHeader")
    @POST
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    public Response readJavaDatasonnetHeader(String message) throws Exception {
        Gizmo theGizmo = new Gizmo();
        theGizmo.setName("gizmo");
        theGizmo.setQuantity(123);
        theGizmo.setInStock(true);
        theGizmo.setColors(Arrays.asList("red", "white", "blue"));
        Manufacturer manufacturer = new Manufacturer();
        manufacturer.setManufacturerName("ACME Corp.");
        manufacturer.setManufacturerCode("ACME123");
        theGizmo.setManufacturer(manufacturer);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        theGizmo.setDate(df.parse("2020-01-06"));
        LOG.infof("Sending to datasonnet: %s", (Object)theGizmo);
        String response = (String)this.producerTemplate.requestBody("direct:readJavaDatasonnetHeader", (Object)theGizmo, String.class);
        LOG.infof("Got response from datasonnet: %s", (Object)response);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
    }
}

