/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.dataset.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.dataset.DataSetEndpoint;
import org.apache.camel.component.dataset.DataSetTestEndpoint;
import org.apache.camel.component.dataset.FileDataSet;
import org.apache.camel.component.dataset.ListDataSet;
import org.apache.camel.component.dataset.SimpleDataSet;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.quarkus.component.dataset.it.CustomDataSet;
import org.apache.camel.support.CamelContextHelper;

@Path(value="/dataset")
@ApplicationScoped
public class DataSetResource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    CamelContext context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/simple")
    public void dataSetSimple(@QueryParam(value="useIndexHeader") boolean useIndexHeader) throws InterruptedException {
        String dataSetName = useIndexHeader ? "simpleDataSetWithIndex" : "simpleDataSet";
        SimpleDataSet simpleDataSet = (SimpleDataSet)CamelContextHelper.lookup((CamelContext)this.context, (String)dataSetName, SimpleDataSet.class);
        DataSetEndpoint endpoint = (DataSetEndpoint)this.context.getEndpoint("dataset:" + dataSetName + "?minRate=50", DataSetEndpoint.class);
        endpoint.expectedMessageCount((int)simpleDataSet.getSize());
        int i = 0;
        while ((long)i < simpleDataSet.getSize()) {
            if (useIndexHeader) {
                this.producerTemplate.sendBodyAndHeader("direct:simpleDataSetWithIndex", simpleDataSet.getDefaultBody(), "CamelDataSetIndex", (Object)i);
            } else {
                this.producerTemplate.sendBody("direct:simpleDataSet", simpleDataSet.getDefaultBody());
            }
            ++i;
        }
        try {
            endpoint.assertIsSatisfied(5000L);
        }
        finally {
            endpoint.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/simple/exception")
    public Response simpleDataSetAssertionException() throws InterruptedException {
        DataSetEndpoint endpoint = (DataSetEndpoint)this.context.getEndpoint("dataset:simpleDataSetForException", DataSetEndpoint.class);
        this.producerTemplate.sendBody("direct:simpleDataSetForException", (Object)"invalid payload");
        try {
            endpoint.assertIsSatisfied(5000L);
        }
        catch (Throwable t) {
            if (t instanceof AssertionError) {
                Response response = Response.ok().build();
                return response;
            }
            Response response = Response.serverError().build();
            return response;
        }
        finally {
            endpoint.reset();
        }
        return Response.serverError().build();
    }

    @GET
    @Path(value="/simple/consumer")
    public void dataSetSimpleConsumer() throws Exception {
        MockEndpoint endpoint = (MockEndpoint)this.context.getEndpoint("mock:simpleDataSetResult", MockEndpoint.class);
        endpoint.expectedBodiesReceived(new Object[]{"<hello>world!</hello>"});
        this.context.getRouteController().startRoute("simple");
        try {
            endpoint.assertIsSatisfied(5000L);
        }
        finally {
            this.context.getRouteController().stopRoute("simple");
            endpoint.reset();
        }
    }

    @GET
    @Path(value="/list")
    public void dataSetList() throws InterruptedException {
        ListDataSet listDataSet = (ListDataSet)CamelContextHelper.lookup((CamelContext)this.context, (String)"listDataSet", ListDataSet.class);
        DataSetEndpoint endpoint = (DataSetEndpoint)this.context.getEndpoint("dataset:listDataSet", DataSetEndpoint.class);
        endpoint.expectedMessageCount((int)listDataSet.getSize());
        this.producerTemplate.sendBodyAndHeader("direct:listDataSet", (Object)"Hello", "CamelDataSetIndex", (Object)0);
        this.producerTemplate.sendBodyAndHeader("direct:listDataSet", (Object)"World", "CamelDataSetIndex", (Object)1);
        try {
            endpoint.assertIsSatisfied(5000L);
        }
        finally {
            endpoint.reset();
        }
    }

    @GET
    @Path(value="/list/consumer")
    public void dataSetListConsumer() throws Exception {
        MockEndpoint endpoint = (MockEndpoint)this.context.getEndpoint("mock:listDataSetResult", MockEndpoint.class);
        endpoint.expectedBodiesReceived(new Object[]{"Hello", "World"});
        this.context.getRouteController().startRoute("list");
        try {
            endpoint.assertIsSatisfied(5000L);
        }
        finally {
            this.context.getRouteController().stopRoute("list");
            endpoint.reset();
        }
    }

    @GET
    @Path(value="/file")
    public void dataSetFile() throws InterruptedException {
        FileDataSet fileDataSet = (FileDataSet)CamelContextHelper.lookup((CamelContext)this.context, (String)"fileDataSet", FileDataSet.class);
        DataSetEndpoint endpoint = (DataSetEndpoint)this.context.getEndpoint("dataset:fileDataSet", DataSetEndpoint.class);
        endpoint.expectedMessageCount((int)fileDataSet.getSize());
        this.producerTemplate.sendBodyAndHeader("direct:fileDataSet", (Object)"Hello World\n", "CamelDataSetIndex", (Object)0);
        try {
            endpoint.assertIsSatisfied(5000L);
        }
        finally {
            endpoint.reset();
        }
    }

    @GET
    @Path(value="/file/delimited")
    public void dataSetFileDelimited() throws InterruptedException {
        FileDataSet fileDataSet = (FileDataSet)CamelContextHelper.lookup((CamelContext)this.context, (String)"fileDataSetDelimited", FileDataSet.class);
        DataSetEndpoint endpoint = (DataSetEndpoint)this.context.getEndpoint("dataset:fileDataSetDelimited", DataSetEndpoint.class);
        endpoint.expectedMessageCount((int)fileDataSet.getSize());
        this.producerTemplate.sendBodyAndHeader("direct:fileDataSetDelimited", (Object)"Hello", "CamelDataSetIndex", (Object)0);
        this.producerTemplate.sendBodyAndHeader("direct:fileDataSetDelimited", (Object)"World", "CamelDataSetIndex", (Object)1);
        try {
            endpoint.assertIsSatisfied(5000L);
        }
        finally {
            endpoint.reset();
        }
    }

    @GET
    @Path(value="/file/consumer")
    public void dataSetFileConsumer() throws Exception {
        MockEndpoint endpoint = (MockEndpoint)this.context.getEndpoint("mock:fileDataSetResult", MockEndpoint.class);
        endpoint.expectedBodiesReceived(new Object[]{"Hello World\n"});
        this.context.getRouteController().startRoute("file");
        try {
            endpoint.assertIsSatisfied(5000L);
        }
        finally {
            this.context.getRouteController().stopRoute("file");
            endpoint.reset();
        }
    }

    @GET
    @Path(value="/custom")
    public void dataSetCustom() throws Exception {
        this.context.getRouteController().startRoute("custom");
        CustomDataSet customDataSet = (CustomDataSet)((Object)CamelContextHelper.lookup((CamelContext)this.context, (String)"customDataSet", CustomDataSet.class));
        DataSetEndpoint endpoint = (DataSetEndpoint)this.context.getEndpoint("dataset:customDataSet", DataSetEndpoint.class);
        endpoint.setExpectedMessageCount((int)customDataSet.getSize());
        try {
            endpoint.assertIsSatisfied(5000L);
        }
        finally {
            this.context.getRouteController().stopRoute("custom");
            endpoint.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/simple/index/off")
    public void dataSetIndexOff() throws InterruptedException {
        SimpleDataSet simpleDataSet = (SimpleDataSet)CamelContextHelper.lookup((CamelContext)this.context, (String)"simpleDataSetIndexOff", SimpleDataSet.class);
        DataSetEndpoint endpoint = (DataSetEndpoint)this.context.getEndpoint("dataset:simpleDataSetIndexOff?dataSetIndex=off", DataSetEndpoint.class);
        endpoint.setExpectedMessageCount((int)simpleDataSet.getSize());
        int i = 0;
        while ((long)i < simpleDataSet.getSize()) {
            if (0 == i % 2) {
                this.producerTemplate.sendBodyAndHeader("direct:simpleDataSetIndexOff", simpleDataSet.getDefaultBody(), "CamelDataSetIndex", (Object)(i - 1));
            } else {
                this.producerTemplate.sendBody("direct:simpleDataSetIndexOff", simpleDataSet.getDefaultBody());
            }
            ++i;
        }
        try {
            endpoint.assertIsSatisfied(5000L);
        }
        finally {
            endpoint.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/simple/index/lenient")
    public void dataSetIndexLenient() throws InterruptedException {
        SimpleDataSet simpleDataSet = (SimpleDataSet)CamelContextHelper.lookup((CamelContext)this.context, (String)"simpleDataSetIndexLenient", SimpleDataSet.class);
        DataSetEndpoint endpoint = (DataSetEndpoint)this.context.getEndpoint("dataset:simpleDataSetIndexLenient?dataSetIndex=lenient", DataSetEndpoint.class);
        endpoint.setExpectedMessageCount((int)simpleDataSet.getSize());
        int i = 0;
        while ((long)i < simpleDataSet.getSize()) {
            if (0 == i % 2) {
                this.producerTemplate.sendBodyAndHeader("direct:simpleDataSetIndexLenient", simpleDataSet.getDefaultBody(), "CamelDataSetIndex", (Object)i);
            } else {
                this.producerTemplate.sendBody("direct:simpleDataSetIndexLenient", simpleDataSet.getDefaultBody());
            }
            ++i;
        }
        try {
            endpoint.assertIsSatisfied(5000L);
        }
        finally {
            endpoint.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/simple/index/strict")
    public Response dataSetIndexStrict(@QueryParam(value="useIndexHeader") boolean useIndexHeader) throws InterruptedException {
        String dataSet = useIndexHeader ? "simpleDataSetIndexStrict" : "simpleDataSetIndexStrictWithoutHeader";
        SimpleDataSet simpleDataSet = (SimpleDataSet)CamelContextHelper.lookup((CamelContext)this.context, (String)dataSet, SimpleDataSet.class);
        DataSetEndpoint endpoint = (DataSetEndpoint)this.context.getEndpoint("dataset:" + dataSet + "?dataSetIndex=strict", DataSetEndpoint.class);
        endpoint.setExpectedMessageCount((int)simpleDataSet.getSize());
        int i = 0;
        while ((long)i < simpleDataSet.getSize()) {
            if (useIndexHeader) {
                this.producerTemplate.sendBodyAndHeader("direct:simpleDataSetIndexStrict", simpleDataSet.getDefaultBody(), "CamelDataSetIndex", (Object)i);
            } else {
                this.producerTemplate.sendBody("direct:simpleDataSetIndexStrictWithoutHeader", simpleDataSet.getDefaultBody());
            }
            ++i;
        }
        try {
            endpoint.assertIsSatisfied(5000L);
        }
        catch (Throwable t) {
            Response response = Response.serverError().entity((Object)t.getMessage()).build();
            return response;
        }
        finally {
            endpoint.reset();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/preload")
    public void dataSetPreloaded() throws Exception {
        SimpleDataSet preloadedDataSet = (SimpleDataSet)CamelContextHelper.lookup((CamelContext)this.context, (String)"preloadedDataSet", SimpleDataSet.class);
        DataSetEndpoint endpoint = (DataSetEndpoint)this.context.getEndpoint("dataset:preloadedDataSet?preloadSize=5", DataSetEndpoint.class);
        endpoint.setExpectedMessageCount((int)preloadedDataSet.getSize());
        this.context.getRouteController().startRoute("preload");
        try {
            endpoint.assertIsSatisfied(5000L);
        }
        finally {
            this.context.getRouteController().stopRoute("preload");
            endpoint.reset();
        }
    }

    @GET
    @Path(value="/test/seda")
    public void dataSetTestSeda() throws Exception {
        this.producerTemplate.sendBody("seda:dataSetTestSeda", (Object)"Hello World");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:dataSetTestSeda").id("dataSetTestSeda")).to("dataset-test:seda:dataSetTestSeda?timeout=0");
            }
        });
        DataSetTestEndpoint endpoint = (DataSetTestEndpoint)this.context.getEndpoint("dataset-test:seda:dataSetTestSeda?timeout=0", DataSetTestEndpoint.class);
        endpoint.expectedMessageCount(1);
        this.producerTemplate.sendBody("direct:dataSetTestSeda", (Object)"Hello World");
        try {
            endpoint.assertIsSatisfied(5000L);
        }
        finally {
            this.context.removeRoute("dataSetTestSeda");
            endpoint.reset();
        }
    }

    @GET
    @Path(value="/test/seda/any/order")
    public void dataSetTestSedaAnyOrder() throws Exception {
        this.producerTemplate.sendBody("seda:dataSetTestSedaAnyOrder", (Object)"Hello World");
        this.producerTemplate.sendBody("seda:dataSetTestSedaAnyOrder", (Object)"Bye World");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:dataSetTestSedaAnyOrder").id("dataSetTestSedaAnyOrder")).to("dataset-test:seda:dataSetTestSedaAnyOrder?timeout=0&anyOrder=true");
            }
        });
        DataSetTestEndpoint endpoint = (DataSetTestEndpoint)this.context.getEndpoint("dataset-test:seda:dataSetTestSedaAnyOrder?timeout=0&anyOrder=true", DataSetTestEndpoint.class);
        endpoint.expectedMessageCount(2);
        this.producerTemplate.sendBody("direct:dataSetTestSedaAnyOrder", (Object)"Bye World");
        this.producerTemplate.sendBody("direct:dataSetTestSedaAnyOrder", (Object)"Hello World");
        try {
            endpoint.assertIsSatisfied(5000L);
        }
        finally {
            this.context.removeRoute("dataSetTestSedaAnyOrder");
            endpoint.reset();
        }
    }

    @GET
    @Path(value="/test/split")
    public void dataSetTestSplit() throws Exception {
        final java.nio.file.Path path = Files.createTempFile("dataSetTestSplit", ".txt", new FileAttribute[0]);
        Files.write(path, "Hello\nWorld\nBye\nWorld".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:dataSetTestSplit").id("dataSetTestSplit")).toF("dataset-test:file:%s?noop=true&split=true&timeout=1000&fileName=%s", new Object[]{path.getParent(), path.getFileName()});
            }
        });
        DataSetTestEndpoint endpoint = (DataSetTestEndpoint)this.context.getEndpoint(String.format("dataset-test:file:%s?noop=true&split=true&timeout=1000&fileName=%s", path.getParent(), path.getFileName()), DataSetTestEndpoint.class);
        endpoint.expectedMessageCount(4);
        this.producerTemplate.sendBody("direct:dataSetTestSplit", (Object)"Hello");
        this.producerTemplate.sendBody("direct:dataSetTestSplit", (Object)"World");
        this.producerTemplate.sendBody("direct:dataSetTestSplit", (Object)"Bye");
        this.producerTemplate.sendBody("direct:dataSetTestSplit", (Object)"World");
        try {
            endpoint.assertIsSatisfied(5000L);
        }
        finally {
            this.context.removeRoute("dataSetTestSplit");
            endpoint.reset();
            Files.deleteIfExists(path);
        }
    }
}

