/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.dataset.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Disposes;
import jakarta.inject.Named;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.dataset.FileDataSet;
import org.apache.camel.component.dataset.ListDataSet;
import org.apache.camel.component.dataset.SimpleDataSet;
import org.apache.camel.quarkus.component.dataset.it.CustomDataSet;

@ApplicationScoped
public class DataSetProducers {
    @Named(value="customDataSet")
    public CustomDataSet customDataSet() {
        CustomDataSet customDataSet = new CustomDataSet();
        customDataSet.setOutputTransformer(new Processor(){

            public void process(Exchange exchange) throws Exception {
                Message message = exchange.getMessage();
                String body = (String)message.getBody(String.class);
                message.setBody((Object)(body + " World"));
            }
        });
        return customDataSet;
    }

    @Named(value="simpleDataSet")
    public SimpleDataSet simpleDataSet() {
        return new SimpleDataSet();
    }

    @Named(value="simpleDataSetForConsumer")
    public SimpleDataSet simpleDataSetForConsumer() {
        return new SimpleDataSet();
    }

    @Named(value="simpleDataSetForException")
    public SimpleDataSet simpleDataSetForException() {
        return new SimpleDataSet(1);
    }

    @Named(value="simpleDataSetWithIndex")
    public SimpleDataSet simpleDataSetWithIndex() {
        return new SimpleDataSet();
    }

    @Named(value="simpleDataSetIndexOff")
    public SimpleDataSet simpleDataSetIndexOff() {
        return new SimpleDataSet();
    }

    @Named(value="simpleDataSetIndexLenient")
    public SimpleDataSet simpleDataSetIndexLenient() {
        return new SimpleDataSet();
    }

    @Named(value="simpleDataSetIndexStrict")
    public SimpleDataSet simpleDataSetIndexStrict() {
        return new SimpleDataSet();
    }

    @Named(value="simpleDataSetIndexStrictWithoutHeader")
    public SimpleDataSet simpleDataSetIndexStrictWithoutHeader() {
        return new SimpleDataSet();
    }

    @Named(value="listDataSet")
    public ListDataSet listDataSet() {
        LinkedList<String> bodies = new LinkedList<String>();
        bodies.add("Hello");
        bodies.add("World");
        return new ListDataSet(bodies);
    }

    @Named(value="listDataSetForConsumer")
    public ListDataSet listDataSetForConsumer() {
        LinkedList<String> bodies = new LinkedList<String>();
        bodies.add("Hello");
        bodies.add("World");
        return new ListDataSet(bodies);
    }

    @Named(value="fileDataSet")
    public FileDataSet fileDataSet() throws IOException {
        Path path = Files.createTempFile("fileDataSet", ".txt", new FileAttribute[0]);
        Files.write(path, "Hello World".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return new FileDataSet(path.toFile());
    }

    @Named(value="fileDataSetDelimited")
    public FileDataSet fileDataSetDelimited() throws IOException {
        Path path = Files.createTempFile("fileDataSetDelimited", ".txt", new FileAttribute[0]);
        Files.write(path, "Hello,World".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return new FileDataSet(path.toFile(), ",");
    }

    @Named(value="preloadedDataSet")
    public SimpleDataSet preloadedDataSet() {
        return new SimpleDataSet();
    }

    @Named(value="sedaDataSet")
    public SimpleDataSet sedaDataSet() {
        return new SimpleDataSet();
    }

    void disposeFileDataSet(@Disposes FileDataSet fileDataSet) throws IOException {
        File file = fileDataSet.getSourceFile();
        Files.deleteIfExists(file.toPath());
    }
}

