/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.dataset.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@QuarkusTest
class DataSetTest {
    DataSetTest() {
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void simpleDataSet(boolean useIndexHeader) {
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("useIndexHeader", new Object[]{useIndexHeader}).get("/dataset/simple", new Object[0])).then()).statusCode(204);
    }

    @Test
    public void simpleDataSetException() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/dataset/simple/exception", new Object[0])).then()).statusCode(200);
    }

    @Test
    public void simpleDataSetConsumer() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/dataset/simple/consumer", new Object[0])).then()).statusCode(204);
    }

    @Test
    public void listDataSet() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/dataset/list", new Object[0])).then()).statusCode(204);
    }

    @Test
    public void listDataSetConsumer() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/dataset/list/consumer", new Object[0])).then()).statusCode(204);
    }

    @Test
    public void fileDataSet() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/dataset/file", new Object[0])).then()).statusCode(204);
    }

    @Test
    public void fileDataSetDelimited() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/dataset/file/delimited", new Object[0])).then()).statusCode(204);
    }

    @Test
    public void fileDataSetConsumer() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/dataset/file/consumer", new Object[0])).then()).statusCode(204);
    }

    @Test
    public void customDataSetProduceConsume() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/dataset/custom", new Object[0])).then()).statusCode(204);
    }

    @Test
    public void indexOff() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/dataset/simple/index/off", new Object[0])).then()).statusCode(204);
    }

    @Test
    public void indexLenient() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/dataset/simple/index/lenient", new Object[0])).then()).statusCode(204);
    }

    @Test
    public void indexStrict() {
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("useIndexHeader", new Object[]{true}).get("/dataset/simple/index/strict", new Object[0])).then()).statusCode(200);
    }

    @Test
    public void indexStrictWithoutIndexHeader() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("useIndexHeader", new Object[]{false}).get("/dataset/simple/index/strict", new Object[0])).then()).statusCode(500)).body(Matchers.containsString((String)"No 'CamelDataSetIndex' header available"), new Matcher[0]);
    }

    @Test
    public void preload() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/dataset/preload", new Object[0])).then()).statusCode(204);
    }

    @Test
    public void datasetTestSeda() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/dataset/test/seda", new Object[0])).then()).statusCode(204);
    }

    @Test
    public void datasetTestSedaAnyOrder() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/dataset/test/seda/any/order", new Object[0])).then()).statusCode(204);
    }

    @Test
    public void datasetTestSplit() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/dataset/test/split", new Object[0])).then()).statusCode(204);
    }
}

