/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.dataformat.it;

import java.net.URI;
import java.time.ZonedDateTime;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Cn;
import net.fortuna.ical4j.model.parameter.Role;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStamp;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.TzId;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Version;

public class ICalUtils {
    protected static Calendar createTestCalendar(ZonedDateTime start, ZonedDateTime end, String summary, String attendee) {
        TimeZoneRegistry registry = TimeZoneRegistryFactory.getInstance().createRegistry();
        String tzId = start.getZone().getId();
        PropertyList propertyList = new PropertyList();
        DateTime ts = new DateTime(true);
        ts.setTime(0L);
        propertyList.add((Property)new DtStamp(ts));
        propertyList.add((Property)new DtStart((Date)ICalUtils.toDateTime(start, registry)));
        propertyList.add((Property)new DtEnd((Date)ICalUtils.toDateTime(end, registry)));
        propertyList.add((Property)new Summary(summary));
        VEvent meeting = new VEvent(propertyList);
        meeting.getProperties().add((Property)new TzId(tzId));
        meeting.getProperties().add((Property)new Uid("00000000"));
        Attendee dev1 = new Attendee(URI.create("mailto:" + attendee));
        dev1.getParameters().add((Parameter)Role.REQ_PARTICIPANT);
        dev1.getParameters().add((Parameter)new Cn(attendee));
        meeting.getProperties().add((Property)dev1);
        Calendar icsCalendar = new Calendar();
        icsCalendar.getProperties().add((Property)Version.VERSION_2_0);
        icsCalendar.getProperties().add((Property)new ProdId("-//Events Calendar//iCal4j 1.0//EN"));
        icsCalendar.getProperties().add((Property)CalScale.GREGORIAN);
        icsCalendar.getComponents().add((Object)meeting);
        return icsCalendar;
    }

    static DateTime toDateTime(ZonedDateTime zonedDateTime, TimeZoneRegistry registry) {
        return new DateTime(zonedDateTime.toInstant().toEpochMilli());
    }
}

