/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.dataformat.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.time.ZonedDateTime;
import net.fortuna.ical4j.model.Calendar;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.quarkus.component.dataformat.it.ICalUtils;
import org.apache.camel.quarkus.component.dataformat.it.model.TestPojo;

@Path(value="/dataformat")
@ApplicationScoped
public class DataformatResource {
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/snakeyaml/marshal/{route}")
    @GET
    @Produces(value={"text/yaml"})
    public String snakeYamlmarshal(@PathParam(value="route") String route, @QueryParam(value="name") String name) {
        return (String)this.producerTemplate.requestBody("direct:snakeyaml-" + route + "-marshal", (Object)new TestPojo(name), String.class);
    }

    @Path(value="/snakeyaml/unmarshal/{route}")
    @POST
    @Consumes(value={"text/yaml"})
    @Produces(value={"text/plain"})
    public String snakeYamlUnmarshal(@PathParam(value="route") String route, String yaml) throws Exception {
        TestPojo pojo = (TestPojo)this.producerTemplate.requestBody("direct:snakeyaml-" + route + "-unmarshal", (Object)yaml, TestPojo.class);
        return pojo.getName();
    }

    @Path(value="/ical/marshal")
    @GET
    @Produces(value={"text/calendar"})
    public String icalmarshal(@QueryParam(value="start") String start, @QueryParam(value="end") String end, @QueryParam(value="summary") String summary, @QueryParam(value="attendee") String attendee) {
        Calendar cal = ICalUtils.createTestCalendar(ZonedDateTime.parse(start), ZonedDateTime.parse(end), summary, attendee);
        return (String)this.producerTemplate.requestBody("direct:ical-marshal", (Object)cal, String.class);
    }

    @Path(value="/ical/unmarshal")
    @POST
    @Consumes(value={"text/calendar"})
    @Produces(value={"text/plain"})
    public String icalUnmarshal(String body) throws Exception {
        Calendar cal = (Calendar)this.producerTemplate.requestBody("direct:ical-unmarshal", (Object)body, Calendar.class);
        return cal.toString();
    }
}

