/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.dataformat.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.time.ZonedDateTime;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@QuarkusTest
class DataformatTest {
    DataformatTest() {
    }

    private static Stream<String> snakeyamlRoutes() {
        return Stream.of("dataformat-component", "dsl");
    }

    @ParameterizedTest
    @MethodSource(value={"snakeyamlRoutes"})
    public void snakeYaml(String route) {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/dataformat/snakeyaml/marshal/" + route + "?name=Camel SnakeYAML"), (Object[])new Object[0]).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"!!org.apache.camel.quarkus.component.dataformat.it.model.TestPojo {name: Camel SnakeYAML}\n"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType("text/yaml").body("!!org.apache.camel.quarkus.component.dataformat.it.model.TestPojo {name: Camel SnakeYAML}").post("/dataformat/snakeyaml/unmarshal/" + route, new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"Camel SnakeYAML"), new Matcher[0]);
    }

    @Test
    public void ical() throws ParseException, IOException {
        ZonedDateTime START = ZonedDateTime.parse("2007-12-03T10:15:30+01:00[Europe/Paris]");
        ZonedDateTime END = ZonedDateTime.parse("2007-12-03T11:16:31+01:00[Europe/Paris]");
        String icalString = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/test.ics"), (Charset)StandardCharsets.UTF_8);
        String actualIcal = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("start", new Object[]{START.toString()}).queryParam("end", new Object[]{END.toString()}).queryParam("summary", new Object[]{"Progress Meeting"}).queryParam("attendee", new Object[]{"dev1@mycompany"}).get("/dataformat/ical/marshal", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Assertions.assertEquals((Object)icalString, (Object)actualIcal.replace("\r", ""));
        String body = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType("text/calendar").body(icalString).post("/dataformat/ical/unmarshal", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Assertions.assertEquals((Object)icalString, (Object)body.replace("\r", ""));
    }
}

