/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.cxf.soap.rest.it;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.eclipse.microprofile.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class CxfRestTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger log = LoggerFactory.getLogger(CxfRestTestResource.class);
    private static final int WILDFLY_PORT = 8080;
    private GenericContainer<?> calculatorContainer;

    public Map<String, String> start() {
        String BASIC_AUTH_USER = "tester";
        String BASIC_AUTH_PASSWORD = UUID.randomUUID().toString();
        String IMAGE_NAME = (String)ConfigProvider.getConfig().getValue("calculator-ws.container.image", String.class);
        try {
            this.calculatorContainer = new GenericContainer(IMAGE_NAME).withExposedPorts(new Integer[]{8080}).withEnv("BASIC_AUTH_USER", "tester").withEnv("BASIC_AUTH_PASSWORD", BASIC_AUTH_PASSWORD).withLogConsumer((Consumer)new Slf4jLogConsumer(log)).waitingFor((WaitStrategy)Wait.forHttp((String)"/calculator-ws/CalculatorService?wsdl"));
            this.calculatorContainer.start();
            return Map.of("camel-quarkus.it.calculator.baseUri", "http://" + this.calculatorContainer.getHost() + ":" + this.calculatorContainer.getMappedPort(8080), "cq.cxf.it.calculator.auth.basic.user", "tester", "cq.cxf.it.calculator.auth.basic.password", BASIC_AUTH_PASSWORD);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            if (this.calculatorContainer != null) {
                this.calculatorContainer.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

