/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.cxf.soap.rest.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.cxf.jaxws.CxfEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.rest.RestBindingMode;
import org.apache.cxf.ext.logging.LoggingFeature;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.eap.quickstarts.wscalculator.calculator.AddOperands;
import org.jboss.eap.quickstarts.wscalculator.calculator.CalculatorService;
import org.jboss.eap.quickstarts.wscalculator.calculator.Result;

@ApplicationScoped
public class CxfSoapRestRoutes
extends RouteBuilder {
    @Inject
    @Named(value="loggingFeatureRest")
    LoggingFeature loggingFeatureRest;
    @ConfigProperty(name="camel-quarkus.it.calculator.baseUri")
    String serviceBaseUri;

    public void configure() {
        this.rest("cxf-soap-rest").bindingMode(RestBindingMode.json).post("post").type(AddOperands.class).outType(Result.class).to("direct:headersPropagation");
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:headersPropagation").process(exchange -> exchange.getIn().setBody((Object)((AddOperands)exchange.getIn().getBody(AddOperands.class)).getArg0()))).to("cxf:bean:soapClientRestEndpoint?defaultOperationName=addOperands")).setHeader("Content-Type", (Expression)this.constant("application/json"))).setBody(e -> ((Object[])e.getMessage().getBody(Object[].class))[0]);
    }

    @Produces
    @ApplicationScoped
    @Named(value="loggingFeatureRest")
    public LoggingFeature loggingFeatureRest() {
        LoggingFeature result = new LoggingFeature();
        result.setPrettyLogging(true);
        return result;
    }

    @Produces
    @SessionScoped
    @Named
    CxfEndpoint soapClientRestEndpoint() {
        CxfEndpoint result = new CxfEndpoint();
        result.setServiceClass(CalculatorService.class);
        result.setAddress(this.calculatorServiceAddress());
        result.setWsdlURL(this.calculatorServiceWsdlUrl());
        result.getFeatures().add(this.loggingFeatureRest);
        return result;
    }

    private String calculatorServiceAddress() {
        return this.serviceBaseUri + "/calculator-ws/CalculatorService";
    }

    private String calculatorServiceWsdlUrl() {
        return "wsdl/CalculatorService.wsdl";
    }
}

