/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.csv.it;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.List;
import java.util.Map;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;

@Path(value="/csv")
@ApplicationScoped
public class CsvResource {
    private static final Logger LOG = Logger.getLogger(CsvResource.class);
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/json-to-csv")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public String json2csv(String json) throws Exception {
        LOG.infof("Transforming json %s", (Object)json);
        List objects = (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
        return (String)this.producerTemplate.requestBody("direct:json-to-csv", (Object)objects, String.class);
    }

    @Path(value="/csv-to-json")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public List<List<Object>> csv2json(String csv) throws Exception {
        return (List)this.producerTemplate.requestBody("direct:csv-to-json", (Object)csv, List.class);
    }
}

