/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.crypto.it;

import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.converter.crypto.CryptoDataFormat;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.DataFormat;

public class CryptoRoutes
extends RouteBuilder {
    public void configure() throws Exception {
        KeyPair keys = this.getKeyPair();
        ((RouteDefinition)this.from("direct:sign-raw").setHeader("CamelSignaturePrivateKey", (Expression)this.constant(keys.getPrivate()))).to("crypto:sign:raw");
        ((RouteDefinition)this.from("direct:verify-raw").setHeader("CamelSignaturePublicKeyOrCert", (Expression)this.constant(keys.getPublic()))).to("crypto:verify:raw");
        this.from("direct:sign").to("crypto:sign:basic?privateKey=#myPrivateKey&algorithm=SHA1withDSA&provider=SUN&secureRandom=#customSecureRandom");
        this.from("direct:verify").to("crypto:verify:basic?publicKey=#myPublicKey&algorithm=SHA1withDSA&provider=SUN&secureRandom=#customSecureRandom");
        CryptoDataFormat cryptoDataFormat = this.getCryptoDataFormat();
        this.from("direct:marshal").marshal((DataFormat)cryptoDataFormat);
        this.from("direct:unmarshal").unmarshal((DataFormat)cryptoDataFormat);
        this.from("direct:marshalPgp").marshal().pgp("pubring.pgp", "sdude@nowhere.net", "sdude");
        this.from("direct:unmarshalPgp").unmarshal().pgp("secring.pgp", "sdude@nowhere.net", "sdude");
    }

    private CryptoDataFormat getCryptoDataFormat() throws NoSuchAlgorithmException {
        KeyGenerator generator = KeyGenerator.getInstance("DES");
        return new CryptoDataFormat("DES", (Key)generator.generateKey());
    }

    private KeyPair getKeyPair() throws NoSuchAlgorithmException {
        return KeyPairGenerator.getInstance("RSA").generateKeyPair();
    }
}

