/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.crypto.it;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;

@Path(value="/crypto")
public class CryptoResource {
    public static final String MESSAGE = "Hello Camel Quarkus Crypto";
    private static final String ALIAS = "bob";
    private static final String KEYSTORE = "crypto.jks";
    private static final String KEYSTORE_PASSWORD = "letmein";
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/signature/sign")
    @POST
    public byte[] sign(@QueryParam(value="raw") boolean raw) {
        String endpoint = "direct:sign" + (raw ? "-raw" : "");
        Exchange exchange = this.producerTemplate.request(endpoint, new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getMessage().setBody((Object)CryptoResource.MESSAGE);
            }
        });
        Message message = exchange.getMessage();
        return (byte[])message.getHeader("CamelDigitalSignature", byte[].class);
    }

    @Path(value="/signature/verify")
    @POST
    @Consumes(value={"text/plain"})
    public Response verify(@QueryParam(value="raw") boolean raw, final String signature) {
        String endpoint = "direct:verify" + (raw ? "-raw" : "");
        Exchange exchange = this.producerTemplate.send(endpoint, new Processor(){

            public void process(Exchange exchange) throws Exception {
                Message message = exchange.getMessage();
                message.setHeader("CamelDigitalSignature", (Object)signature);
                message.setBody((Object)CryptoResource.MESSAGE);
            }
        });
        if (exchange.isFailed()) {
            return Response.serverError().build();
        }
        return Response.ok((Object)(exchange.getMessage().getHeaders().size() == 0 ? 1 : 0)).build();
    }

    @Path(value="/encrypt")
    @POST
    public byte[] encryptPayload(String payload) {
        return (byte[])this.producerTemplate.requestBody("direct:marshal", (Object)payload, byte[].class);
    }

    @Path(value="/decrypt")
    @POST
    @Produces(value={"text/plain"})
    public String decryptPgpPayload(byte[] payload) {
        return (String)this.producerTemplate.requestBody("direct:unmarshal", (Object)payload, String.class);
    }

    @Path(value="/encrypt/pgp")
    @POST
    public byte[] encryptPgpPayload(String payload) {
        return (byte[])this.producerTemplate.requestBody("direct:marshalPgp", (Object)payload, byte[].class);
    }

    @Path(value="/decrypt/pgp")
    @POST
    @Produces(value={"text/plain"})
    public String decryptPayload(byte[] payload) {
        return (String)this.producerTemplate.requestBody("direct:unmarshalPgp", (Object)payload, String.class);
    }

    @jakarta.enterprise.inject.Produces
    public KeyStore keyStore() throws Exception {
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream in = this.getClass().getResourceAsStream("/crypto.jks");){
            keystore.load(in, KEYSTORE_PASSWORD.toCharArray());
        }
        return keystore;
    }

    @jakarta.enterprise.inject.Produces
    @Named
    public PrivateKey myPrivateKey(KeyStore keyStore) throws Exception {
        return (PrivateKey)keyStore.getKey(ALIAS, KEYSTORE_PASSWORD.toCharArray());
    }

    @jakarta.enterprise.inject.Produces
    @Named
    public PublicKey myPublicKey(KeyStore keyStore) throws Exception {
        Certificate cert = keyStore.getCertificate(ALIAS);
        return cert.getPublicKey();
    }

    @jakarta.enterprise.inject.Produces
    @Named
    public SecureRandom customSecureRandom() {
        return new SecureRandom();
    }
}

