/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.crypto.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
class CryptoTest {
    CryptoTest() {
    }

    @Test
    public void signAndVerifySignature() {
        byte[] signatureBytes = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().post("/crypto/signature/sign", new Object[0])).then()).statusCode(200)).extract().body().asByteArray();
        Assertions.assertTrue((boolean)Base64.isBase64((byte[])signatureBytes));
        byte[] badSignature = "an invalid signature".getBytes(StandardCharsets.UTF_8);
        ((ValidatableResponse)((Response)RestAssured.given().body(Base64.encodeBase64String((byte[])badSignature)).post("/crypto/signature/verify", new Object[0])).then()).statusCode(500);
        String signature = new String(signatureBytes, StandardCharsets.UTF_8);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(signature).post("/crypto/signature/verify", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"true"), new Matcher[0]);
    }

    @Test
    public void encryptDecryptMessage() {
        byte[] encrypted = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("Hello Camel Quarkus Crypto").post("/crypto/encrypt", new Object[0])).then()).statusCode(200)).extract().body().asByteArray();
        String decrypted = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(encrypted).post("/crypto/decrypt", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Assertions.assertEquals((Object)"Hello Camel Quarkus Crypto", (Object)decrypted);
    }

    @Test
    public void encryptDecryptPgpMessage() {
        byte[] encrypted = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("Hello Camel Quarkus Crypto").post("/crypto/encrypt/pgp", new Object[0])).then()).statusCode(200)).extract().body().asByteArray();
        String decrypted = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(encrypted).post("/crypto/decrypt/pgp", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Assertions.assertEquals((Object)"Hello Camel Quarkus Crypto", (Object)decrypted);
    }
}

