/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.couchdb.it;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.couchdb.CouchDbOperations;
import org.apache.camel.quarkus.component.couchdb.it.CouchdbTestDocument;
import org.jboss.logging.Logger;
import org.lightcouch.NoDocumentException;

@Path(value="/couchdb")
@ApplicationScoped
public class CouchdbResource {
    private static final Logger LOG = Logger.getLogger(CouchdbResource.class);
    private final ConcurrentLinkedQueue<CouchdbTestDocument> loggedEvents = new ConcurrentLinkedQueue();
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/create")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CouchdbTestDocument create(CouchdbTestDocument document) {
        LOG.info((Object)"Invoking create");
        Exchange createExchange = this.producerTemplate.request("couchdb:http://{{camel.couchdb.test.server.authority}}/database", e -> e.getMessage().setBody((Object)document.toJsonObject()));
        document.setId((String)createExchange.getMessage().getHeader("CouchDbId", String.class));
        document.setRevision((String)createExchange.getMessage().getHeader("CouchDbRev", String.class));
        return document;
    }

    @Path(value="/get")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String get(CouchdbTestDocument document) {
        LOG.info((Object)"Invoking get");
        Exchange getExchange = this.producerTemplate.request("couchdb:http://{{camel.couchdb.test.server.authority}}/database", e -> {
            e.getMessage().setBody((Object)document.toJsonObject());
            e.getMessage().setHeader("CouchDbMethod", (Object)CouchDbOperations.GET);
            e.getMessage().setHeader("CouchDbId", (Object)document.getId());
        });
        if (getExchange.getException(NoDocumentException.class) != null) {
            return null;
        }
        return (String)getExchange.getMessage().getBody(String.class);
    }

    @Path(value="/update")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CouchdbTestDocument update(CouchdbTestDocument document) {
        LOG.info((Object)"Invoking update");
        Exchange updateExchange = this.producerTemplate.request("couchdb:http://{{camel.couchdb.test.server.authority}}/database", e -> e.getMessage().setBody((Object)document.toJsonObject()));
        document.setId((String)updateExchange.getMessage().getHeader("CouchDbId", String.class));
        document.setRevision((String)updateExchange.getMessage().getHeader("CouchDbRev", String.class));
        return document;
    }

    @Path(value="/delete")
    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CouchdbTestDocument delete(CouchdbTestDocument document) {
        LOG.info((Object)"Invoking delete");
        Exchange deleteExchange = this.producerTemplate.request("couchdb:http://{{camel.couchdb.test.server.authority}}/database", e -> {
            e.getMessage().setBody((Object)document.toJsonObject());
            e.getMessage().setHeader("CouchDbMethod", (Object)CouchDbOperations.DELETE);
        });
        document.setId((String)deleteExchange.getMessage().getHeader("CouchDbId", String.class));
        document.setRevision((String)deleteExchange.getMessage().getHeader("CouchDbRev", String.class));
        return document;
    }

    void logEvent(CouchdbTestDocument event) {
        this.loggedEvents.add(event);
    }

    @Path(value="/get-events")
    @GET
    @Produces(value={"application/json"})
    public Collection<CouchdbTestDocument> getEvents() {
        return this.loggedEvents;
    }
}

