/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.couchdb.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.concurrent.TimeUnit;
import org.apache.camel.quarkus.component.couchdb.it.CouchdbTestDocument;
import org.apache.camel.quarkus.component.couchdb.it.CouchdbTestResource;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=CouchdbTestResource.class)
class CouchdbTest {
    CouchdbTest() {
    }

    @Test
    public void crudShouldSucceed() {
        CouchdbTestDocument toBeCreated = new CouchdbTestDocument();
        toBeCreated.setValue("create");
        CouchdbTestDocument created = (CouchdbTestDocument)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)toBeCreated).put("/couchdb/create", new Object[0])).then()).statusCode(200)).extract().as(CouchdbTestDocument.class);
        Assertions.assertNotNull((Object)created);
        Assertions.assertNotNull((Object)created.getId());
        Assertions.assertNotNull((Object)created.getRevision());
        CouchdbTestDocument retrieved = (CouchdbTestDocument)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)created).get("/couchdb/get", new Object[0])).then()).statusCode(200)).extract().as(CouchdbTestDocument.class);
        Assertions.assertNotNull((Object)retrieved);
        Assertions.assertEquals((Object)created.getId(), (Object)retrieved.getId());
        Assertions.assertEquals((Object)created.getRevision(), (Object)retrieved.getRevision());
        Assertions.assertEquals((Object)created.getValue(), (Object)retrieved.getValue());
        retrieved.setValue("update");
        CouchdbTestDocument updated = (CouchdbTestDocument)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)retrieved).put("/couchdb/update", new Object[0])).then()).statusCode(200)).extract().as(CouchdbTestDocument.class);
        Assertions.assertNotNull((Object)updated);
        Assertions.assertEquals((Object)retrieved.getId(), (Object)updated.getId());
        Assertions.assertNotEquals((Object)retrieved.getRevision(), (Object)updated.getRevision());
        retrieved = (CouchdbTestDocument)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)updated).get("/couchdb/get", new Object[0])).then()).statusCode(200)).extract().as(CouchdbTestDocument.class);
        Assertions.assertNotNull((Object)retrieved);
        Assertions.assertEquals((Object)updated.getId(), (Object)retrieved.getId());
        Assertions.assertEquals((Object)updated.getRevision(), (Object)retrieved.getRevision());
        Assertions.assertEquals((Object)"update", (Object)retrieved.getValue());
        CouchdbTestDocument deleted = (CouchdbTestDocument)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)updated).delete("/couchdb/delete", new Object[0])).then()).statusCode(200)).extract().as(CouchdbTestDocument.class);
        Assertions.assertNotNull((Object)deleted);
        Assertions.assertEquals((Object)updated.getId(), (Object)deleted.getId());
        Assertions.assertNotEquals((Object)updated.getRevision(), (Object)deleted.getRevision());
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)created).get("/couchdb/get", new Object[0])).then()).statusCode(204);
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> ((Response)RestAssured.given().get("/couchdb/get-events", new Object[0])).path("size()", new String[0]).equals(3));
        CouchdbTestDocument[] events = (CouchdbTestDocument[])((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/couchdb/get-events", new Object[0])).then()).statusCode(200)).extract().as(CouchdbTestDocument[].class);
        Assertions.assertEquals((int)3, (int)events.length);
        CouchdbTestDocument firstEvent = events[0];
        Assertions.assertNotNull((Object)firstEvent);
        Assertions.assertEquals((Object)"create", (Object)firstEvent.getValue());
        Assertions.assertEquals((Object)created.getId(), (Object)firstEvent.getId());
        Assertions.assertEquals((Object)created.getRevision(), (Object)firstEvent.getRevision());
        CouchdbTestDocument secondEvent = events[1];
        Assertions.assertNotNull((Object)secondEvent);
        Assertions.assertEquals((Object)"update", (Object)secondEvent.getValue());
        Assertions.assertEquals((Object)updated.getId(), (Object)secondEvent.getId());
        Assertions.assertEquals((Object)updated.getRevision(), (Object)secondEvent.getRevision());
        CouchdbTestDocument thirdEvent = events[2];
        Assertions.assertNotNull((Object)thirdEvent);
        Assertions.assertEquals((Object)"delete", (Object)thirdEvent.getValue());
        Assertions.assertEquals((Object)deleted.getId(), (Object)thirdEvent.getId());
        Assertions.assertEquals((Object)deleted.getRevision(), (Object)thirdEvent.getRevision());
    }
}

