/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.couchdb.it;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Map;
import org.apache.camel.util.CollectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.TestcontainersConfiguration;

public class CouchdbTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CouchdbTestResource.class);
    private static final int COUCHDB_PORT = 5984;
    private static final String COUCHDB_IMAGE = "couchdb:2.3.1";
    private GenericContainer container;

    public Map<String, String> start() {
        LOGGER.info(TestcontainersConfiguration.getInstance().toString());
        try {
            this.container = new GenericContainer(COUCHDB_IMAGE).withExposedPorts(new Integer[]{5984}).waitingFor((WaitStrategy)Wait.forListeningPort());
            this.container.start();
            String authority = this.container.getHost() + ":" + this.container.getMappedPort(5984).toString();
            return CollectionHelper.mapOf((Object)"camel.couchdb.test.server.authority", (Object)authority, (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

