/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.couchbase.it;

import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.manager.bucket.BucketSettings;
import com.couchbase.client.java.manager.bucket.BucketType;
import com.couchbase.client.java.manager.view.DesignDocument;
import com.couchbase.client.java.manager.view.View;
import com.couchbase.client.java.view.DesignDocumentNamespace;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import org.apache.camel.util.CollectionHelper;
import org.testcontainers.couchbase.CouchbaseContainer;
import org.testcontainers.utility.DockerImageName;

public class CouchbaseTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final DockerImageName COUCHBASE_IMAGE = DockerImageName.parse((String)"couchbase/server:6.5.1");
    public static final int KV_PORT = 11210;
    public static final int MANAGEMENT_PORT = 8091;
    public static final int VIEW_PORT = 8092;
    public static final int QUERY_PORT = 8093;
    public static final int SEARCH_PORT = 8094;
    protected String bucketName = "testBucket";
    private CustomCouchbaseContainer container;
    protected Cluster cluster;

    public Map<String, String> start() {
        this.container = new CustomCouchbaseContainer();
        this.container.start();
        this.initBucket();
        return CollectionHelper.mapOf((Object)"couchbase.connection.uri", (Object)this.getConnectionUri(), (Object[])new Object[]{"couchbase.bucket.name", this.bucketName});
    }

    public void stop() {
        if (this.cluster != null) {
            this.cluster.buckets().dropBucket(this.bucketName);
            this.cluster.disconnect();
        }
        if (this.container != null) {
            this.container.stop();
        }
    }

    public String getConnectionUri() {
        return String.format("couchbase:http://%s:%d?bucket=%s&username=%s&password=%s", this.getHostname(), this.getPort(), this.bucketName, this.getUsername(), this.getPassword());
    }

    public String getUsername() {
        return this.container.getUsername();
    }

    public String getPassword() {
        return this.container.getPassword();
    }

    public String getHostname() {
        return this.container.getHost();
    }

    public int getPort() {
        return this.container.getBootstrapHttpDirectPort();
    }

    private void initBucket() {
        this.cluster = Cluster.connect((String)this.container.getConnectionString(), (String)this.getUsername(), (String)this.getPassword());
        this.cluster.buckets().createBucket(BucketSettings.create((String)this.bucketName).bucketType(BucketType.COUCHBASE).flushEnabled(true));
        this.cluster.bucket(this.bucketName);
        DesignDocument designDoc = new DesignDocument(this.bucketName, Collections.singletonMap(this.bucketName, new View("function (doc, meta) {  emit(meta.id, doc);}")));
        this.cluster.bucket(this.bucketName).viewIndexes().upsertDesignDocument(designDoc, DesignDocumentNamespace.PRODUCTION);
        this.cluster.bucket(this.bucketName).waitUntilReady(Duration.ofSeconds(30L));
        for (int i = 0; i < 3; ++i) {
            this.cluster.bucket(this.bucketName).defaultCollection().upsert("DocumentID_" + i, (Object)("hello" + i));
        }
        this.cluster.bucket(this.bucketName).waitUntilReady(Duration.ofSeconds(30L));
    }

    private class CustomCouchbaseContainer
    extends CouchbaseContainer {
        public CustomCouchbaseContainer() {
            super(COUCHBASE_IMAGE);
            this.addFixedExposedPort(11210, 11210);
            this.addFixedExposedPort(8091, 8091);
            this.addFixedExposedPort(8092, 8092);
            this.addFixedExposedPort(8093, 8093);
            this.addFixedExposedPort(8094, 8094);
        }
    }
}

