/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.couchbase.it;

import com.couchbase.client.java.kv.GetResult;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@Path(value="/couchbase")
@ApplicationScoped
@Consumes(value={"text/plain"})
public class CouchbaseResource {
    private static final Logger LOG = Logger.getLogger(CouchbaseResource.class);
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;
    @ConfigProperty(name="couchbase.connection.uri")
    String connectionUri;
    @ConfigProperty(name="couchbase.bucket.name")
    String bucketName;
    @ConfigProperty(name="couchbase.timeout", defaultValue="120000")
    long timeout;

    @PUT
    @Path(value="id/{id}")
    @Produces(value={"text/plain"})
    public boolean insert(@PathParam(value="id") String id, String msg) {
        LOG.infof("inserting message %s with id %s", (Object)msg, (Object)id);
        String endpoint = String.format("%s&queryTimeout=%s", this.connectionUri, this.timeout);
        return (Boolean)this.producerTemplate.requestBodyAndHeader(endpoint, (Object)msg, "CCB_ID", (Object)id, Boolean.class);
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"text/plain"})
    public String getById(@PathParam(value="id") String id) {
        LOG.infof("Getting object with id : %s", (Object)id);
        String endpoint = String.format("%s&operation=%s&queryTimeout=%s", this.connectionUri, "CCB_GET", this.timeout);
        GetResult result = (GetResult)this.producerTemplate.requestBodyAndHeader(endpoint, null, "CCB_ID", (Object)id, GetResult.class);
        return result != null ? (String)result.contentAs(String.class) : null;
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"text/plain"})
    public boolean delete(@PathParam(value="id") String id) {
        LOG.infof("Deleting object with id : %s", (Object)id);
        String endpoint = String.format("%s&operation=%s&queryTimeout=%s", this.connectionUri, "CCB_DEL", this.timeout);
        this.producerTemplate.sendBodyAndHeader(endpoint, null, "CCB_ID", (Object)id);
        return true;
    }

    @GET
    @Path(value="poll")
    @Produces(value={"text/plain"})
    public String poll() {
        LOG.infof("polling one document", new Object[0]);
        String endpoint = String.format("%s&designDocumentName=%s&viewName=%s&limit=1", this.connectionUri, this.bucketName, this.bucketName);
        GetResult result = (GetResult)this.consumerTemplate.receiveBody(endpoint, this.timeout, GetResult.class);
        return result != null ? (String)result.contentAs(String.class) : null;
    }
}

